---
navigation:
  title: "Electric Machines"
  icon: "modern_industrialization:assembler"
  position: 105
  parent: modern_industrialization:electric_age.md
item_ids:
  - modern_industrialization:configurable_chest
  - modern_industrialization:polarizer
  - modern_industrialization:assembler
---

# Electric Machines

Electric machines work exactly the same as steam machines, except that they require electricity instead of steam and they progressively overclock recipes up to 32 EU/t.

You can use REI to view the recipes for the electric version of the machines you are already familiar with.

<ItemImage id="modern_industrialization:lubricant_bucket" />

Lubricant is a fluid that can be obtained by mixing creosote and redstone. Right-click an electric machine with a lubricant container such as a lubricant bucket to overclock it manually.

Each 25 mb of lubricant will add 1 (overclocking) efficiency tick to the machine.

The Configurable Chest is not a machine, but once you have Analog Circuits, you can craft it!

It has 27 configurable slots, and auto-eject functionality! Very useful for automation!

<Recipe id="modern_industrialization:electric_age/machine/configurable_chest_asbl" />

The Polarizer polarizes stuff. It doesn't have many recipes yet, but it is already useful to automate Motors!

<Recipe id="modern_industrialization:electric_age/machine/polarizer_asbl" />

The first machine you'll want to make a lot of! The Assembler allows you to automate almost all recipes, up to 3 per Assembler if you use slot locking.

<Recipe id="modern_industrialization:electric_age/machine/assembler_asbl" />

We strongly suggest that you automate Machine Hull, Analog Circuits, Motors, Pistons, Robot Arms and Conveyor Belts using Assemblers as soon as possible, that will make crafting electric machines basically free!

## Redstone Control Modules

<ItemImage id="modern_industrialization:redstone_control_module" />

A Redstone Control Module can be used to control the behavior of electric machines and multiblocks with redstone signals.

Configure the module in your hand, then insert it into the machine or multiblock controller.

## Overclock Upgrades

<ItemImage id="modern_industrialization:basic_upgrade" />

Regular electric machines have an overclock capped at 32 EU/t, and electric multiblocks have an overclock capped at 128 EU/t.

In the machine or multiblock's menu, add upgades to increase its maximum overclock! Check REI for the exact amounts.

