# PowerShell script to list all .jar files in the current directory, excluding those ending with .jar.disabled or .jar.old

Get-ChildItem -Path . -Filter *.jar |
    Where-Object { $_.Name -notlike "*.jar.disabled" -and $_.Name -notlike "*.jar.old" } |
    Select-Object -ExpandProperty Name |
    Out-File -FilePath jar_files.txt -Encoding utf8

Write-Host "The list of .jar files has been saved to jar_files.txt"