/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei.category;

import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWithButtons;
import giselle.jei_mekanism_multiblocks.client.gui.LongSliderWidget;
import giselle.jei_mekanism_multiblocks.client.gui.LongSliderWithButtons;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockCategory;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import giselle.jei_mekanism_multiblocks.client.jei.ResultWidget;
import giselle.jei_mekanism_multiblocks.client.jei.category.ICostConsumer;
import giselle.jei_mekanism_multiblocks.common.util.VolumeTextHelper;
import java.util.function.Consumer;
import mekanism.api.datamaps.IMekanismDataMapTypes;
import mekanism.api.datamaps.chemical.attribute.CooledCoolant;
import mekanism.api.datamaps.chemical.attribute.IChemicalCoolant;
import mekanism.api.math.MathUtils;
import mekanism.common.registries.MekanismChemicals;
import mekanism.common.util.HeatUtils;
import mekanism.common.util.MekanismUtils;
import mekanism.common.util.UnitDisplayUtils;
import mekanism.generators.common.GeneratorsLang;
import mekanism.generators.common.MekanismGenerators;
import mekanism.generators.common.config.MekanismGeneratorsConfig;
import mekanism.generators.common.registries.GeneratorsBlocks;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.neoforged.neoforge.fluids.FluidStack;
import org.jetbrains.annotations.Nullable;

public class FissionReactorCategory
extends MultiblockCategory<FissionReactorCategoryWidget> {
    public FissionReactorCategory(IGuiHelper helper) {
        super(helper, MekanismGenerators.rl((String)"fission_reactor"), FissionReactorCategoryWidget.class, (Component)GeneratorsLang.FISSION_REACTOR.translate(), new ItemStack((ItemLike)GeneratorsBlocks.CONTROL_ROD_ASSEMBLY));
    }

    @Override
    protected void getRecipeCatalystItemStacks(Consumer<ItemStack> consumer) {
        super.getRecipeCatalystItemStacks(consumer);
        consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FISSION_REACTOR_CASING));
        consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FISSION_REACTOR_PORT));
        consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER));
        consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FISSION_FUEL_ASSEMBLY));
        consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.CONTROL_ROD_ASSEMBLY));
        consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.REACTOR_GLASS));
    }

    public static class FissionReactorCategoryWidget
    extends MultiblockWidget {
        protected IntSliderWithButtons portsWidget;
        protected IntSliderWithButtons logicAdaptersWidget;
        protected LongSliderWithButtons burnRateWidget;

        @Override
        protected void collectOtherConfigs(Consumer<AbstractWidget> consumer) {
            super.collectOtherConfigs(consumer);
            this.portsWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.ports", 0, 4, 0);
            consumer.accept(this.portsWidget);
            ((IntSliderWidget)((Object)this.portsWidget.getSlider())).addValueChangeHanlder(this::onPortsChanged);
            this.logicAdaptersWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.logic_adapters", 0, 0, 0);
            consumer.accept(this.logicAdaptersWidget);
            ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).addValueChangeHanlder(this::onLogicAdaptersChanged);
            this.burnRateWidget = new LongSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.burn_rate", 0L, 0L, 0L);
            consumer.accept(this.burnRateWidget);
            ((LongSliderWidget)((Object)this.burnRateWidget.getSlider())).addValueChangeHanlder(this::onBurnRateChanged);
            this.updatePortsSliderLimit();
            this.updateBurnRateSliderLimit();
            this.setBurnRate(this.getMaxBurnRate());
        }

        @Override
        protected void onDimensionChanged() {
            super.onDimensionChanged();
            this.updatePortsSliderLimit();
            this.updateBurnRateSliderLimit();
            this.setBurnRate(this.getMaxBurnRate());
        }

        public void updatePortsSliderLimit() {
            IntSliderWidget portsSlider = (IntSliderWidget)((Object)this.portsWidget.getSlider());
            int valves = portsSlider.getValue();
            portsSlider.setMaxValue(this.getSideBlocks());
            portsSlider.setValue(valves);
            this.updateLogicAdaptersSliderLimit();
        }

        public void updateLogicAdaptersSliderLimit() {
            IntSliderWidget adaptersSlider = (IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider());
            int adapters = adaptersSlider.getValue();
            adaptersSlider.setMaxValue(this.getSideBlocks() - this.getPortCount());
            adaptersSlider.setValue(adapters);
        }

        protected void onPortsChanged(int ports) {
            this.updateLogicAdaptersSliderLimit();
            this.markNeedUpdate();
        }

        protected void onLogicAdaptersChanged(int logicAdapters) {
            this.markNeedUpdate();
        }

        public void updateBurnRateSliderLimit() {
            LongSliderWidget burnRateSlider = (LongSliderWidget)((Object)this.burnRateWidget.getSlider());
            long burnRate = burnRateSlider.getValue();
            burnRateSlider.setMaxValue(this.getMaxBurnRate());
            burnRateSlider.setValue(burnRate);
        }

        protected void onBurnRateChanged(long burnRate) {
            this.markNeedUpdate();
        }

        @Override
        protected void collectCost(ICostConsumer consumer) {
            super.collectCost(consumer);
            int corners = this.getCornerBlocks();
            int sides = this.getSideBlocks();
            int ports = this.getPortCount();
            sides -= ports;
            int logicAdapter = this.getLogicAdapterCount();
            sides -= logicAdapter;
            int casings = 0;
            int glasses = 0;
            if (this.isUseGlass()) {
                casings = corners;
                glasses = sides;
            } else {
                casings = corners + sides;
                glasses = 0;
            }
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FISSION_REACTOR_CASING, casings));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FISSION_REACTOR_PORT, ports));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FISSION_REACTOR_LOGIC_ADAPTER, logicAdapter));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.FISSION_FUEL_ASSEMBLY, this.getFissionFuelAssemblyCount()));
            consumer.accept(new ItemStack((ItemLike)GeneratorsBlocks.CONTROL_ROD_ASSEMBLY, this.getControlRodAssemblyCount()));
            consumer.accept(new ItemStack((ItemLike)this.getGlassBlock(), glasses));
        }

        @Override
        protected void collectResult(Consumer<AbstractWidget> consumer) {
            super.collectResult(consumer);
            long coolantCapacity = this.getCooledCoolantCapacity();
            long heatedCoolantCapacity = this.getHeatedCoolantCapacity();
            long maxBurnRate = this.getMaxBurnRate();
            long burnRate = this.getBurnRate();
            long fuelCapacity = this.getFuelCapacity();
            consumer.accept(new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.max_burn_rate"), VolumeTextHelper.formatMBt(maxBurnRate)));
            this.createStableTempWidget(consumer, new FluidStack((Fluid)Fluids.WATER, 1).getHoverName(), burnRate, 0.5, HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency());
            this.createStableTempWidget(consumer, MekanismChemicals.SODIUM.getTextComponent(), burnRate, (IChemicalCoolant)FissionReactorCategoryWidget.getCooledCoolant());
            consumer.accept(new ResultWidget((Component)GeneratorsLang.FISSION_COOLANT_TANK.translate(), VolumeTextHelper.formatMB(coolantCapacity)));
            consumer.accept(new ResultWidget((Component)GeneratorsLang.FISSION_FUEL_TANK.translate(), VolumeTextHelper.formatMB(fuelCapacity)));
            consumer.accept(new ResultWidget((Component)GeneratorsLang.FISSION_HEATED_COOLANT_TANK.translate(), VolumeTextHelper.formatMB(heatedCoolantCapacity)));
            consumer.accept(new ResultWidget((Component)GeneratorsLang.FISSION_WASTE_TANK.translate(), VolumeTextHelper.formatMB(fuelCapacity)));
        }

        @Nullable
        public static CooledCoolant getCooledCoolant() {
            return (CooledCoolant)MekanismChemicals.SODIUM.getData(IMekanismDataMapTypes.INSTANCE.cooledChemicalCoolant());
        }

        private void createStableTempWidget(Consumer<AbstractWidget> consumer, Component with, long toBurn, IChemicalCoolant coolant) {
            this.createStableTempWidget(consumer, with, toBurn, coolant.conductivity(), coolant.thermalEnthalpy());
        }

        private void createStableTempWidget(Consumer<AbstractWidget> consumer, Component with, long toBurn, double conductivity, double thermalEnthalpy) {
            double stableTemp = this.getCoolingStableTemp(toBurn, conductivity, thermalEnthalpy);
            ResultWidget tempWidget = new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.temp_with", (Object[])new Object[]{with}), MekanismUtils.getTemperatureDisplay((double)stableTemp, (UnitDisplayUtils.TemperatureUnit)UnitDisplayUtils.TemperatureUnit.KELVIN, (boolean)false));
            consumer.accept(tempWidget);
            boolean warning = false;
            if (Double.isInfinite(stableTemp)) {
                warning = true;
                tempWidget.getValueLabel().setFGColor(0xFF0000);
            } else if (stableTemp >= 1200.0) {
                warning = true;
                double ratio = Mth.inverseLerp((double)stableTemp, (double)1200.0, (double)1800.0);
                int g = (int)Mth.clampedLerp((double)255.0, (double)0.0, (double)ratio);
                tempWidget.getValueLabel().setFGColor(0xFF0000 + g * 256);
            }
            MutableComponent burnRateTooltip = Component.translatable((String)"text.jei_mekanism_multiblocks.tooltip.when_burn_rate", (Object[])new Object[]{VolumeTextHelper.formatMBt(toBurn)});
            if (warning) {
                tempWidget.setJeiTooltip(new Component[]{burnRateTooltip, Component.translatable((String)"text.jei_mekanism_multiblocks.tooltip.warning").withStyle(ChatFormatting.RED), Component.translatable((String)"text.jei_mekanism_multiblocks.tooltip.reactor_will_damage").withStyle(ChatFormatting.RED)});
            } else {
                tempWidget.setJeiTooltip(new Component[]{burnRateTooltip});
            }
            long heatedCoolant = this.getHeatedCoolant(stableTemp, conductivity, thermalEnthalpy);
            ResultWidget heatingRateWidget = new ResultWidget((Component)Component.translatable((String)"text.jei_mekanism_multiblocks.result.heating_rate_with", (Object[])new Object[]{with}), VolumeTextHelper.formatMBt(heatedCoolant));
            heatingRateWidget.setJeiTooltip(new Component[]{burnRateTooltip});
            consumer.accept(heatingRateWidget);
        }

        private void simulateTemp(double coolantConductivity) {
            long coolantCapacity = this.getCooledCoolantCapacity();
            long toBurn = (long)this.getFissionFuelAssemblyCount() * MekanismGeneratorsConfig.generators.burnPerAssembly.get();
            long burnHeat = MathUtils.multiplyClamped((long)toBurn, (long)MekanismGeneratorsConfig.generators.energyPerFissionFuel.get());
            double heatCapacity = this.getHeatCapacity();
            double boilEfficiency = 1.0;
            double heat = 300.0 * heatCapacity;
            double prevHeat = 0.0;
            for (int i = 0; i < 100; ++i) {
                double temp = heat / heatCapacity;
                heat += (double)burnHeat;
                double boilHeat = boilEfficiency * (temp - HeatUtils.BASE_BOIL_TEMP) * heatCapacity;
                double caseCoolantHeat = boilHeat * coolantConductivity;
                long coolantHeated = (int)(HeatUtils.getSteamEnergyEfficiency() * caseCoolantHeat / HeatUtils.getWaterThermalEnthalpy());
                if ((coolantHeated = Math.max(0L, Math.min(coolantHeated, coolantCapacity))) > 0L) {
                    caseCoolantHeat = (double)coolantHeated * HeatUtils.getWaterThermalEnthalpy() / HeatUtils.getSteamEnergyEfficiency();
                    heat -= caseCoolantHeat;
                }
                System.out.println("Temp: " + heat / heatCapacity);
                if (prevHeat == heat) {
                    System.out.println("Stabled");
                    break;
                }
                prevHeat = heat;
            }
        }

        public long getHeatedCoolant(double temp, double coolantConductivity, double thermalEnthalpy) {
            double boilEfficiency = 1.0;
            double boilHeat = boilEfficiency * (temp - HeatUtils.BASE_BOIL_TEMP) * this.getHeatCapacity();
            double caseCoolantHeat = boilHeat * coolantConductivity;
            long coolantHeated = MathUtils.clampToLong((double)(caseCoolantHeat / thermalEnthalpy));
            return Math.max(0L, Math.min(coolantHeated, this.getCooledCoolantCapacity()));
        }

        public long getCooledCoolantCapacity() {
            return this.getDimensionVolume() * MekanismGeneratorsConfig.generators.fissionCooledCoolantPerTank.get();
        }

        public long getHeatedCoolantCapacity() {
            return (long)this.getDimensionVolume() * MekanismGeneratorsConfig.generators.fissionHeatedCoolantPerTank.get();
        }

        public long getMaxBurnRate() {
            return (long)this.getFissionFuelAssemblyCount() * MekanismGeneratorsConfig.generators.burnPerAssembly.get();
        }

        public long getFuelCapacity() {
            return (long)this.getFissionFuelAssemblyCount() * MekanismGeneratorsConfig.generators.maxFuelPerAssembly.get();
        }

        public double getHeatCapacity() {
            return MekanismGeneratorsConfig.generators.fissionCasingHeatCapacity.get() * (double)this.getDimensionCasingBlocks();
        }

        public double getCoolingStableTemp(long toBurn, double coolantConductivity, double thermalEnthalpy) {
            long coolantCapacity = this.getCooledCoolantCapacity();
            long burnHeat = MathUtils.multiplyClamped((long)toBurn, (long)MekanismGeneratorsConfig.generators.energyPerFissionFuel.get());
            double heatCapacity = this.getHeatCapacity();
            double boilEfficiency = 1.0;
            double coolantHeated = (double)burnHeat / thermalEnthalpy;
            if (coolantHeated > (double)coolantCapacity) {
                return Double.POSITIVE_INFINITY;
            }
            double boilHeat = (double)burnHeat / coolantConductivity;
            return boilHeat / (heatCapacity * boilEfficiency) + HeatUtils.BASE_BOIL_TEMP;
        }

        public int getControlRodAssemblyCount() {
            Vec3i inner = this.getDimensionInner();
            int rods = 0;
            rods += (inner.getX() + 1) / 2 * ((inner.getZ() + 1) / 2);
            return rods += (inner.getX() + 0) / 2 * ((inner.getZ() + 0) / 2);
        }

        public int getFissionFuelAssemblyCount() {
            Vec3i inner = this.getDimensionInner();
            return this.getControlRodAssemblyCount() * (inner.getY() - 1);
        }

        public int getPortCount() {
            return ((IntSliderWidget)((Object)this.portsWidget.getSlider())).getValue();
        }

        public void setPortCount(int portCount) {
            ((IntSliderWidget)((Object)this.portsWidget.getSlider())).setValue(portCount);
        }

        public int getLogicAdapterCount() {
            return ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).getValue();
        }

        public void setLogicAdapterCount(int logicAdapterCount) {
            ((IntSliderWidget)((Object)this.logicAdaptersWidget.getSlider())).setValue(logicAdapterCount);
        }

        public long getBurnRate() {
            return ((LongSliderWidget)((Object)this.burnRateWidget.getSlider())).getValue();
        }

        public void setBurnRate(long burnRate) {
            ((LongSliderWidget)((Object)this.burnRateWidget.getSlider())).setValue(burnRate);
        }

        @Override
        public int getDimensionWidthMin() {
            return 3;
        }

        @Override
        public int getDimensionWidthMax() {
            return 18;
        }

        @Override
        public int getDimensionLengthMin() {
            return 3;
        }

        @Override
        public int getDimensionLengthMax() {
            return 18;
        }

        @Override
        public int getDimensionHeightMin() {
            return 4;
        }

        @Override
        public int getDimensionHeightMax() {
            return 18;
        }

        @Override
        public Block getGlassBlock() {
            return (Block)GeneratorsBlocks.REACTOR_GLASS.get();
        }
    }
}

