/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.world.structures.action;

import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.structures.jisaw.PieceEntry;
import com.github.L_Ender.cataclysm.structures.jisaw.context.StructureContext;
import com.github.L_Ender.cataclysm.structures.jisaw.element.CataclysmJigsawSinglePoolElement;
import com.github.L_Ender.cataclysm.util.BoxOctree;
import com.github.L_Ender.cataclysm.world.structures.action.StructureAction;
import com.github.L_Ender.cataclysm.world.structures.action.StructureActionType;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.templatesystem.LiquidSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.phys.AABB;

public class TransformAction
extends StructureAction {
    private static final Codec<Either<ResourceLocation, StructureTemplate>> TEMPLATE_CODEC = Codec.of(TransformAction::encodeTemplate, (Decoder)ResourceLocation.CODEC.map(Either::left));
    public static final MapCodec<TransformAction> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)TEMPLATE_CODEC.listOf().fieldOf("output").forGetter(action -> action.output), (App)Codec.INT.optionalFieldOf("x_offset", (Object)0).forGetter(action -> action.xOffset), (App)Codec.INT.optionalFieldOf("y_offset", (Object)0).forGetter(action -> action.yOffset), (App)Codec.INT.optionalFieldOf("z_offset", (Object)0).forGetter(action -> action.zOffset)).apply((Applicative)builder, TransformAction::new));
    private final List<Either<ResourceLocation, StructureTemplate>> output;
    private final int xOffset;
    private final int yOffset;
    private final int zOffset;

    private static <T> DataResult<T> encodeTemplate(Either<ResourceLocation, StructureTemplate> either, DynamicOps<T> ops, T data) {
        return either.left().isEmpty() ? DataResult.error(() -> "yungsapi - Cannot serialize a runtime pool element") : ResourceLocation.CODEC.encode((Object)((ResourceLocation)either.left().get()), ops, data);
    }

    public TransformAction(List<Either<ResourceLocation, StructureTemplate>> output, int xOffset, int yOffset, int zOffset) {
        this.output = output;
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.zOffset = zOffset;
    }

    @Override
    public StructureActionType<?> type() {
        return StructureActionType.TRANSFORM;
    }

    @Override
    public void apply(StructureContext ctx, PieceEntry targetPieceEntry) {
        StructureTemplateManager templateManager = ctx.structureTemplateManager();
        if (templateManager == null) {
            Cataclysm.LOGGER.error("Missing required field 'structureTemplateManager' for transform action!");
            return;
        }
        CataclysmJigsawSinglePoolElement old = (CataclysmJigsawSinglePoolElement)targetPieceEntry.getPiece().getElement();
        WorldgenRandom rand = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        rand.setFeatureSeed((long)targetPieceEntry.getPiece().getPosition().getX(), targetPieceEntry.getPiece().getPosition().getY(), targetPieceEntry.getPiece().getPosition().getX());
        Either<ResourceLocation, StructureTemplate> newTemplate = this.output.get(rand.nextInt(this.output.size()));
        CataclysmJigsawSinglePoolElement newElement = new CataclysmJigsawSinglePoolElement(newTemplate, old.processors, old.getProjection(), old.overrideLiquidSettings, old.name, old.maxCount, old.minRequiredDepth, old.maxPossibleDepth, old.isPriority, old.ignoreBounds, old.condition, old.enhancedTerrainAdaptation, old.deadendPool, old.modifiers);
        BlockPos offset = new BlockPos(this.xOffset, this.yOffset, this.zOffset);
        offset = offset.rotate(targetPieceEntry.getPiece().getRotation());
        BlockPos newPos = targetPieceEntry.getPiece().getPosition().offset((Vec3i)offset);
        BoundingBox newBoundingBox = newElement.getBoundingBox(templateManager, newPos, targetPieceEntry.getPiece().getRotation());
        AABB newAabb = AABB.of((BoundingBox)newBoundingBox);
        ((BoxOctree)targetPieceEntry.getBoxOctree().getValue()).removeBox(targetPieceEntry.getPieceAabb());
        ((BoxOctree)targetPieceEntry.getBoxOctree().getValue()).addBox(newAabb);
        PoolElementStructurePiece newPiece = new PoolElementStructurePiece(templateManager, (StructurePoolElement)newElement, newPos, targetPieceEntry.getPiece().getGroundLevelDelta(), targetPieceEntry.getPiece().getRotation(), newBoundingBox, old.overrideLiquidSettings.orElse(LiquidSettings.APPLY_WATERLOGGING));
        targetPieceEntry.setPiece(newPiece);
    }
}

