/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.items;

import com.github.L_Ender.cataclysm.config.CMConfig;
import com.github.L_Ender.cataclysm.entity.projectile.Phantom_Arrow_Entity;
import com.github.L_Ender.cataclysm.init.ModDataComponents;
import com.github.L_Ender.cataclysm.init.ModItems;
import com.github.L_Ender.cataclysm.items.Components.CursedBowComponent;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.event.EventHooks;

public class Cursed_bow
extends ProjectileWeaponItem {
    public Cursed_bow(Item.Properties group) {
        super(group);
    }

    public InteractionResultHolder<ItemStack> use(Level p_40672_, Player p_40673_, InteractionHand p_40674_) {
        ItemStack itemstack;
        boolean flag = !p_40673_.getProjectile(itemstack = p_40673_.getItemInHand(p_40674_)).isEmpty();
        InteractionResultHolder ret = EventHooks.onArrowNock((ItemStack)itemstack, (Level)p_40672_, (Player)p_40673_, (InteractionHand)p_40674_, (boolean)flag);
        if (ret != null) {
            return ret;
        }
        if (!p_40673_.hasInfiniteMaterials() && !flag) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        p_40673_.startUsingItem(p_40674_);
        return InteractionResultHolder.consume((Object)itemstack);
    }

    public int getUseDuration(ItemStack stack, LivingEntity pEntity) {
        return 72000;
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean held) {
        LivingEntity living;
        super.inventoryTick(stack, level, entity, i, held);
        boolean using = entity instanceof LivingEntity && (living = (LivingEntity)entity).getUseItem().equals(stack);
        int useTime = Cursed_bow.getUseTime(stack);
        CursedBowComponent flaskContents = (CursedBowComponent)stack.getOrDefault(ModDataComponents.CURSED_BOW, (Object)CursedBowComponent.EMPTY);
        if (flaskContents.PrevUseTime() != flaskContents.UseTime()) {
            stack.update(ModDataComponents.CURSED_BOW, (Object)flaskContents, component -> component.tryAddDose(useTime, Cursed_bow.getUseTime(stack)));
        }
        int maxLoadTime = Cursed_bow.getMaxLoadTime();
        if (using && useTime < maxLoadTime) {
            int set = useTime + 1;
            Cursed_bow.setUseTime(stack, set);
        }
        if (!using && (float)useTime > 0.0f) {
            Cursed_bow.setUseTime(stack, Math.max(0, useTime - 5));
        }
    }

    private static int getMaxLoadTime() {
        return 20;
    }

    public static int getUseTime(ItemStack stack) {
        CursedBowComponent flaskContents = (CursedBowComponent)stack.getOrDefault(ModDataComponents.CURSED_BOW, (Object)CursedBowComponent.EMPTY);
        return flaskContents.UseTime();
    }

    public static void setUseTime(ItemStack stack, int useTime) {
        CursedBowComponent flaskContents = (CursedBowComponent)stack.getOrDefault(ModDataComponents.CURSED_BOW, (Object)CursedBowComponent.EMPTY);
        stack.update(ModDataComponents.CURSED_BOW, (Object)flaskContents, component -> component.tryAddDose(useTime, Cursed_bow.getUseTime(stack)));
    }

    public static float getLerpedUseTime(ItemStack stack, float f) {
        CursedBowComponent flaskContents = (CursedBowComponent)stack.getOrDefault(ModDataComponents.CURSED_BOW, (Object)CursedBowComponent.EMPTY);
        float prev = flaskContents.PrevUseTime();
        float current = flaskContents.UseTime();
        return prev + f * (current - prev);
    }

    public static float getPullingAmount(ItemStack itemStack, float partialTicks) {
        return Math.min(Cursed_bow.getLerpedUseTime(itemStack, partialTicks) / (float)Cursed_bow.getMaxLoadTime(), 1.0f);
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public static float getPowerForTime(int i) {
        float f = (float)i / (float)Cursed_bow.getMaxLoadTime();
        if ((f = (f * f + f * 2.0f) / 3.0f) > 1.0f) {
            f = 1.0f;
        }
        return f;
    }

    private Entity getPlayerLookTarget(Level level, LivingEntity living) {
        Entity pointedEntity = null;
        double range = 40.0;
        Vec3 srcVec = living.getEyePosition();
        Vec3 lookVec = living.getViewVector(1.0f);
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        float var9 = 2.0f;
        List possibleList = level.getEntities((Entity)living, living.getBoundingBox().expandTowards(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range).inflate((double)var9, (double)var9, (double)var9));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.isPickable()) continue;
            float borderSize = possibleEntity.getPickRadius();
            AABB collisionBB = possibleEntity.getBoundingBox().inflate((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.clip(srcVec, destVec);
            if (collisionBB.contains(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                pointedEntity = possibleEntity;
                hitDist = 0.0;
                continue;
            }
            if (!interceptPos.isPresent() || !((possibleDist = srcVec.distanceTo((Vec3)interceptPos.get())) < hitDist) && hitDist != 0.0) continue;
            pointedEntity = possibleEntity;
            hitDist = possibleDist;
        }
        return pointedEntity;
    }

    public void releaseUsing(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            ItemStack itemstack = player.getProjectile(stack);
            Entity pointedEntity = this.getPlayerLookTarget(level, entityLiving);
            if (!itemstack.isEmpty()) {
                int i = this.getUseDuration(stack, entityLiving) - timeLeft;
                if ((i = EventHooks.onArrowLoose((ItemStack)stack, (Level)level, (Player)player, (int)i, (!itemstack.isEmpty() ? 1 : 0) != 0)) < 0) {
                    return;
                }
                float f = Cursed_bow.getPowerForTime(i);
                if (!((double)f < 0.1)) {
                    List list = Cursed_bow.draw((ItemStack)stack, (ItemStack)itemstack, (LivingEntity)player);
                    if (level instanceof ServerLevel) {
                        ServerLevel serverlevel = (ServerLevel)level;
                        if (!list.isEmpty()) {
                            this.shoot(serverlevel, (LivingEntity)player, player.getUsedItemHand(), stack, list, f, 1.0f, f == 1.0f, pointedEntity);
                        }
                    }
                    level.playSound((Player)null, player.getX(), player.getY(), player.getZ(), SoundEvents.ARROW_SHOOT, SoundSource.PLAYERS, 1.0f, 1.0f / (level.getRandom().nextFloat() * 0.4f + 1.2f) + f * 0.5f);
                    player.awardStat(Stats.ITEM_USED.get((Object)this));
                }
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    protected void shoot(ServerLevel level, LivingEntity shooter, InteractionHand hand, ItemStack weapon, List<ItemStack> projectileItems, float velocity, float inaccuracy, boolean isCrit, @Nullable Entity target) {
        f = EnchantmentHelper.processProjectileSpread((ServerLevel)level, (ItemStack)weapon, (Entity)shooter, (float)0.0f);
        f1 = projectileItems.size() == 1 ? 0.0f : 2.0f * f / (float)(projectileItems.size() - 1);
        f2 = (float)((projectileItems.size() - 1) % 2) * f1 / 2.0f;
        f3 = 1.0f;
        block0: for (i = 0; i < projectileItems.size(); ++i) {
            itemstack = projectileItems.get(i);
            if (itemstack.isEmpty()) continue;
            hommingArrows = itemstack.is(Items.ARROW);
            arrowcount = itemstack.is(Items.ARROW) != false ? 3 : 2;
            offsetangle = itemstack.is(Items.ARROW) != false ? 12.0f : 3.0f;
            flag1 = shooter.hasInfiniteMaterials() != false || itemstack.getItem() instanceof ArrowItem != false && ((ArrowItem)itemstack.getItem()).isInfinite(itemstack, weapon, shooter) != false;
            for (j = 0; j < arrowcount; ++j) {
                block9: {
                    block8: {
                        abstractarrow = this.createArrow((Level)level, shooter, weapon, itemstack, isCrit);
                        abstractarrow = this.customArrow(abstractarrow);
                        if (!hommingArrows) break block8;
                        if (!(target instanceof LivingEntity)) ** GOTO lbl-1000
                        tango = (LivingEntity)target;
                        if (!target.isAlliedTo((Entity)shooter)) {
                            hommingArrowEntity = new Phantom_Arrow_Entity((Level)level, shooter, tango);
                            hommingArrowEntity.setBaseDamage(CMConfig.PlayerPhantomArrowbasedamage * (double)velocity);
                            abstractarrow = hommingArrowEntity;
                        } else lbl-1000:
                        // 2 sources

                        {
                            hommingArrowEntity = new Phantom_Arrow_Entity((Level)level, shooter);
                            hommingArrowEntity.setBaseDamage(CMConfig.PlayerPhantomArrowbasedamage * (double)velocity);
                            abstractarrow = hommingArrowEntity;
                        }
                        break block9;
                    }
                    abstractarrow.setBaseDamage(abstractarrow.getBaseDamage() + 0.5);
                }
                if (j != 1) {
                    abstractarrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                } else if (flag1 || shooter.hasInfiniteMaterials() && (itemstack.getItem() == Items.SPECTRAL_ARROW || itemstack.getItem() == Items.TIPPED_ARROW)) {
                    abstractarrow.pickup = AbstractArrow.Pickup.ALLOWED;
                }
                abstractarrow.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + ((float)j - (float)(arrowcount - 1) / 2.0f) * offsetangle, 0.0f, velocity * 3.0f, inaccuracy);
                if (f == 1.0f) {
                    abstractarrow.setCritArrow(true);
                }
                level.addFreshEntity((Entity)abstractarrow);
                if (weapon.isEmpty()) continue block0;
            }
        }
    }

    protected AbstractArrow createArrow(Level level, LivingEntity shooter, ItemStack weapon, ItemStack ammo, boolean isCrit) {
        ArrowItem arrowitem1;
        Item var8 = ammo.getItem();
        ArrowItem var10000 = var8 instanceof ArrowItem ? (arrowitem1 = (ArrowItem)var8) : (ArrowItem)Items.ARROW;
        ArrowItem arrowitem = var10000;
        AbstractArrow abstractarrow = arrowitem.createArrow(level, ammo, shooter, weapon);
        if (isCrit) {
            abstractarrow.setCritArrow(true);
        }
        return this.customArrow(abstractarrow, ammo, weapon);
    }

    public AbstractArrow customArrow(AbstractArrow arrow) {
        return arrow;
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 16;
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.is((Item)ModItems.CURSED_BOW.get()) || !newStack.is((Item)ModItems.CURSED_BOW.get());
    }

    public Predicate<ItemStack> getAllSupportedProjectiles() {
        return ARROW_ONLY;
    }

    public int getDefaultProjectileRange() {
        return 64;
    }

    protected void shootProjectile(LivingEntity shooter, Projectile projectile, int index, float velocity, float inaccuracy, float angle, @Nullable LivingEntity target) {
        projectile.shootFromRotation((Entity)shooter, shooter.getXRot(), shooter.getYRot() + angle, 0.0f, velocity, inaccuracy);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flags) {
        tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursed_bow.desc").withStyle(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)Component.translatable((String)"item.cataclysm.cursed_bow2.desc").withStyle(ChatFormatting.DARK_GREEN));
    }
}

