/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.entity.effect;

import com.github.L_Ender.cataclysm.client.particle.Options.StormParticleOptions;
import com.github.L_Ender.cataclysm.init.ModEntities;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Void_Vortex_Entity
extends Entity {
    protected static final EntityDataAccessor<Integer> LIFESPAN = SynchedEntityData.defineId(Void_Vortex_Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> CASTER = SynchedEntityData.defineId(Void_Vortex_Entity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private boolean madeOpenNoise = false;
    private boolean madeCloseNoise = false;
    @Nullable
    private LivingEntity owner;

    public Void_Vortex_Entity(EntityType<?> entityTypeIn, Level worldIn) {
        super(entityTypeIn, worldIn);
    }

    public Void_Vortex_Entity(Level worldIn, double x, double y, double z, float p_i47276_8_, LivingEntity casterIn, int span) {
        this((EntityType)ModEntities.VOID_VORTEX.get(), worldIn);
        this.setLifespan(span);
        this.setOwner(casterIn);
        this.setYRot(p_i47276_8_ * 57.295776f);
        this.setPos(x, y, z);
        if (!worldIn.isClientSide) {
            this.setCasterID(casterIn.getId());
        }
    }

    public Packet<ClientGamePacketListener> getAddEntityPacket(ServerEntity entity) {
        return new ClientboundAddEntityPacket((Entity)this, entity);
    }

    public void tick() {
        super.tick();
        if (this.tickCount == 1) {
            if (this.getLifespan() == 0) {
                this.setLifespan(60);
            }
            if (this.level().isClientSide) {
                this.owner = (LivingEntity)this.level().getEntity(this.getCasterID());
            }
        }
        if (!this.madeOpenNoise) {
            this.gameEvent((Holder)GameEvent.ENTITY_PLACE);
            this.playSound(SoundEvents.END_PORTAL_SPAWN, 1.0f, 1.0f + this.random.nextFloat() * 0.2f);
            this.madeOpenNoise = true;
        }
        if (Math.min(this.tickCount, this.getLifespan()) >= 16) {
            if (this.level().isClientSide) {
                float r = 0.4f;
                float g = 0.1f;
                float b = 0.8f;
                this.level().addParticle((ParticleOptions)new StormParticleOptions(r, g, b, 2.5f + this.random.nextFloat() * 0.9f, 5.0f + this.random.nextFloat() * 0.9f, this.getId()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)new StormParticleOptions(r, g, b, 2.25f + this.random.nextFloat() * 0.6f, 4.25f + this.random.nextFloat() * 0.6f, this.getId()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)new StormParticleOptions(r, g, b, 2.0f + this.random.nextFloat() * 0.45f, 3.5f + this.random.nextFloat() * 0.45f, this.getId()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)new StormParticleOptions(r, g, b, 1.5f + this.random.nextFloat() * 0.25f, 2.75f + this.random.nextFloat() * 0.45f, this.getId()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)new StormParticleOptions(r, g, b, 1.25f + this.random.nextFloat() * 0.25f, 2.0f + this.random.nextFloat() * 0.45f, this.getId()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)new StormParticleOptions(r, g, b, 1.0f + this.random.nextFloat() * 0.25f, 1.25f + this.random.nextFloat() * 0.45f, this.getId()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
                this.level().addParticle((ParticleOptions)new StormParticleOptions(r, g, b, 0.75f + this.random.nextFloat() * 0.25f, 0.5f + this.random.nextFloat() * 0.45f, this.getId()), this.getX(), this.getY(), this.getZ(), 0.0, 0.0, 0.0);
            }
            AABB screamBox = new AABB(this.getX() - 3.0, this.getY(), this.getZ() - 3.0, this.getX() + 3.0, this.getY() + 15.0, this.getZ() + 3.0);
            for (LivingEntity entity : this.level().getEntitiesOfClass(LivingEntity.class, screamBox)) {
                if (this.isAlliedTo((Entity)entity) || this.owner != null && (this.owner.equals((Object)entity) || this.owner.isAlliedTo((Entity)entity))) continue;
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.getAbilities().invulnerable) continue;
                }
                Vec3 diff = entity.position().subtract(this.position().add(0.0, 0.0, 0.0));
                diff = diff.normalize().scale(0.075);
                entity.setDeltaMovement(entity.getDeltaMovement().add(0.0, -2.0, 0.0).subtract(diff));
            }
        }
        this.setLifespan(this.getLifespan() - 1);
        if (this.getLifespan() <= 16 && !this.madeCloseNoise) {
            this.gameEvent((Holder)GameEvent.ENTITY_PLACE);
            this.madeCloseNoise = true;
        }
        if (this.getLifespan() <= 0) {
            this.level().explode((Entity)this.owner, this.getX(), this.getY(), this.getZ(), 2.0f, false, Level.ExplosionInteraction.NONE);
            this.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    public int getLifespan() {
        return (Integer)this.entityData.get(LIFESPAN);
    }

    public void setLifespan(int i) {
        this.entityData.set(LIFESPAN, (Object)i);
    }

    public int getCasterID() {
        return (Integer)this.entityData.get(CASTER);
    }

    public void setCasterID(int id) {
        this.entityData.set(CASTER, (Object)id);
    }

    public void setOwner(@Nullable LivingEntity p_19719_) {
        this.owner = p_19719_;
        this.setCasterID(p_19719_ == null ? 0 : p_19719_.getId());
    }

    @Nullable
    public LivingEntity getOwner() {
        Entity entity;
        if (this.owner == null && this.getCasterID() != 0 && this.level() instanceof ServerLevel && (entity = ((ServerLevel)this.level()).getEntity(this.getCasterID())) instanceof LivingEntity) {
            this.owner = (LivingEntity)entity;
        }
        return this.owner;
    }

    protected void defineSynchedData(SynchedEntityData.Builder p_326229_) {
        p_326229_.define(LIFESPAN, (Object)300);
        p_326229_.define(CASTER, (Object)-1);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setLifespan(compound.getInt("Lifespan"));
        this.setCasterID(compound.getInt("CasterId"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Lifespan", this.getLifespan());
        compound.putInt("CasterId", this.getCasterID());
    }
}

