/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

public final class ExperienceUtils {
    private static final double EXPERIENCE_MULTIPLIER = 1.0;
    private static final double PERCENT_MULTIPLIER = 100.0;

    private ExperienceUtils() {
    }

    public static double getPercentOfLevelCompleted(double experience, int level) {
        double thisLvlExp = ExperienceUtils.getXPNeededForOnlyLevel(level);
        double lastLvlExp = ExperienceUtils.getXPNeededForNextLevel(level) - thisLvlExp;
        double currentExp = experience - lastLvlExp;
        return Math.min(100.0, 100.0 - (thisLvlExp - currentExp) / thisLvlExp * 100.0);
    }

    private static double getXPNeededForOnlyLevel(int currentLevel) {
        if (currentLevel == 0) {
            return ExperienceUtils.getXPNeededForNextLevel(currentLevel);
        }
        return ExperienceUtils.getXPNeededForNextLevel(currentLevel) - ExperienceUtils.getXPNeededForNextLevel(currentLevel - 1);
    }

    public static double getXPNeededForNextLevel(int currentLevel) {
        if (currentLevel <= 0) {
            return 1.0;
        }
        return Math.max(1.0, 1.0 + 5.0 * (double)currentLevel + 0.005 * (double)(currentLevel * currentLevel * currentLevel));
    }

    public static int calculateLevel(double xp) {
        int startLevel = 0;
        while (ExperienceUtils.getXPNeededForNextLevel(startLevel) < xp) {
            ++startLevel;
        }
        return startLevel;
    }
}

