/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.research;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.research.IGlobalResearch;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.ILocalResearch;
import com.minecolonies.api.research.ILocalResearchTree;
import com.minecolonies.api.research.IResearchEffect;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.util.ResearchState;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.research.LocalResearch;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GlobalResearch
implements IGlobalResearch {
    private final List<SizedIngredient> costList = new ArrayList<SizedIngredient>();
    private final ResourceLocation id;
    @Nullable
    private final ResourceLocation parent;
    private final ResourceLocation branch;
    private final TranslatableContents name;
    private final TranslatableContents subtitle;
    private final List<IResearchEffect> effects = new ArrayList<IResearchEffect>();
    private final int depth;
    private final int sortOrder;
    private final boolean onlyChild;
    private final boolean hidden;
    private final boolean autostart;
    private final boolean instant;
    private final boolean immutable;
    private final List<ResourceLocation> children = new ArrayList<ResourceLocation>();
    private final List<IResearchRequirement> requirements = new ArrayList<IResearchRequirement>();

    public GlobalResearch(ResourceLocation id, @Nullable ResourceLocation parent, ResourceLocation branch, TranslatableContents name, TranslatableContents subtitle, int depth, int sortOrder, boolean onlyChild, boolean hidden, boolean autostart, boolean instant, boolean immutable) {
        this.id = id;
        this.name = name;
        this.subtitle = subtitle;
        this.branch = branch;
        this.parent = parent;
        this.depth = depth;
        this.sortOrder = sortOrder;
        this.onlyChild = onlyChild;
        this.hidden = hidden;
        this.autostart = autostart;
        this.instant = instant;
        this.immutable = immutable;
    }

    @Override
    public boolean canResearch(int uni_level, @NotNull ILocalResearchTree localTree) {
        IGlobalResearch parentResearch = this.parent == null ? null : IGlobalResearchTree.getInstance().getResearch(this.branch, this.parent);
        ILocalResearch localParentResearch = this.parent == null ? null : localTree.getResearch(this.branch, this.parent);
        ILocalResearch localResearch = localTree.getResearch(this.getBranch(), this.getId());
        return !(localResearch != null || !this.canDisplay(uni_level) || parentResearch != null && (localParentResearch == null || localParentResearch.getState() != ResearchState.FINISHED) || parentResearch != null && parentResearch.hasResearchedChild(localTree) && parentResearch.hasOnlyChild() || this.depth >= 6 && localTree.branchFinishedHighestLevel(this.branch));
    }

    @Override
    public boolean canDisplay(int uni_level) {
        return uni_level >= this.depth;
    }

    @Override
    public boolean hasEnoughResources(IItemHandler inventory) {
        if (this.costList.isEmpty()) {
            return true;
        }
        for (SizedIngredient ingredient : this.costList) {
            if (ingredient.ingredient().hasNoItems()) {
                return false;
            }
            int requiredCount = ingredient.count();
            int totalCount = InventoryUtils.getItemCountInItemHandler(inventory, (Predicate<ItemStack>)ingredient.ingredient());
            if (totalCount >= requiredCount) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<SizedIngredient> getCostList() {
        return ImmutableList.copyOf(this.costList);
    }

    @Override
    public void startResearch(@NotNull ILocalResearchTree localResearchTree) {
        if (localResearchTree.getResearch(this.branch, this.id) == null) {
            LocalResearch research = new LocalResearch(this.id, this.branch, this.depth);
            if (this.instant) {
                research.setProgress(IGlobalResearchTree.getInstance().getBranchData(this.branch).getBaseTime(research.getDepth()));
            }
            research.setState(ResearchState.IN_PROGRESS);
            localResearchTree.addResearch(this.branch, research);
        }
    }

    @Override
    @NotNull
    public ResourceLocation getId() {
        return this.id;
    }

    @Override
    public TranslatableContents getName() {
        return this.name;
    }

    @Override
    public TranslatableContents getSubtitle() {
        return this.subtitle;
    }

    @Override
    @Nullable
    public ResourceLocation getParent() {
        return this.parent;
    }

    @Override
    public ResourceLocation getBranch() {
        return this.branch;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    public int getSortOrder() {
        return this.sortOrder;
    }

    @Override
    public boolean isInstant() {
        return this.instant;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public boolean isAutostart() {
        return this.autostart;
    }

    @Override
    public boolean isImmutable() {
        return this.immutable;
    }

    @Override
    public boolean hasOnlyChild() {
        return this.onlyChild;
    }

    @Override
    public boolean hasResearchedChild(@NotNull ILocalResearchTree localTree) {
        for (ResourceLocation child : this.children) {
            IGlobalResearch childResearch = IGlobalResearchTree.getInstance().getResearch(this.branch, child);
            ILocalResearch localResearch = localTree.getResearch(childResearch.getBranch(), childResearch.getId());
            if (localResearch == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void addChild(IGlobalResearch child) {
        this.children.add(child.getId());
    }

    @Override
    public void addChild(ResourceLocation child) {
        this.children.add(child);
    }

    @Override
    public void addCost(SizedIngredient cost) {
        this.costList.add(cost);
    }

    @Override
    public void addEffect(IResearchEffect effect) {
        this.effects.add(effect);
    }

    @Override
    public void addRequirement(IResearchRequirement requirement) {
        this.requirements.add(requirement);
    }

    @Override
    public List<IResearchRequirement> getResearchRequirements() {
        return this.requirements;
    }

    @Override
    public List<ResourceLocation> getChildren() {
        return this.children;
    }

    @Override
    public List<IResearchEffect> getEffects() {
        return this.effects;
    }
}

