/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.worker;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IAssignsCitizen;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class BuildingHiringModeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"building_hiring_mode", BuildingHiringModeMessage::new);
    private final HiringMode mode;
    private final int moduleId;

    public BuildingHiringModeMessage(@NotNull IBuildingView building, HiringMode mode, int moduleId) {
        super(TYPE, building);
        this.mode = mode;
        this.moduleId = moduleId;
    }

    protected BuildingHiringModeMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.mode = HiringMode.values()[buf.readInt()];
        this.moduleId = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.mode.ordinal());
        buf.writeInt(this.moduleId);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.moduleId);
        if (iBuildingModule instanceof IAssignsCitizen) {
            IAssignsCitizen module = (IAssignsCitizen)iBuildingModule;
            module.setHiringMode(this.mode);
        }
    }
}

