/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.warehouse;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import com.minecolonies.core.util.SortingUtils;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class SortWarehouseMessage
extends AbstractBuildingServerMessage<BuildingWareHouse> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"sort_warehouse_message", SortWarehouseMessage::new);
    private static final int REQUIRED_LEVEL_TO_SORT_WAREHOUSE = 3;

    public SortWarehouseMessage(IBuildingView building) {
        super(TYPE, building);
    }

    protected SortWarehouseMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, BuildingWareHouse building) {
        IItemHandler iItemHandler;
        if (building.getBuildingLevel() >= 3 && (iItemHandler = building.getItemHandlerCap()) instanceof CombinedItemHandler) {
            CombinedItemHandler combinedInv = (CombinedItemHandler)iItemHandler;
            SortingUtils.sort((HolderLookup.Provider)player.level().registryAccess(), combinedInv);
        }
    }
}

