/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.fields;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.modules.BuildingExtensionsModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class AssignmentModeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"assignment_mode", AssignmentModeMessage::new);
    private final int id;
    private final boolean assignmentMode;

    public AssignmentModeMessage(@NotNull IBuildingView building, boolean assignmentMode, int runtimeID) {
        super(TYPE, building);
        this.assignmentMode = assignmentMode;
        this.id = runtimeID;
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.id);
        buf.writeBoolean(this.assignmentMode);
    }

    protected AssignmentModeMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.id = buf.readInt();
        this.assignmentMode = buf.readBoolean();
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        if (building.hasModule(BuildingExtensionsModule.class)) {
            ((BuildingExtensionsModule)building.getModule(this.id)).setAssignManually(this.assignmentMode);
        }
    }
}

