/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.SettingsModule;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class TriggerSettingMessage
extends AbstractBuildingServerMessage<AbstractBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"trigger_setting", TriggerSettingMessage::new);
    private final ResourceLocation key;
    private final ISetting<?> value;
    private final int moduleID;

    public TriggerSettingMessage(IBuildingView building, ISettingKey<?> key, ISetting<?> value, int moduleID) {
        super(TYPE, building);
        this.key = key.getUniqueId();
        this.value = value;
        this.moduleID = moduleID;
    }

    protected TriggerSettingMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.moduleID = buf.readInt();
        this.key = buf.readResourceLocation();
        this.value = (ISetting)StandardFactoryController.getInstance().deserialize(buf);
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.moduleID);
        buf.writeResourceLocation(this.key);
        StandardFactoryController.getInstance().serialize(buf, this.value);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, AbstractBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.moduleID);
        if (iBuildingModule instanceof SettingsModule) {
            SettingsModule module = (SettingsModule)iBuildingModule;
            module.updateSetting(new SettingKey(this.value.getClass(), this.key), this.value, player);
        }
    }
}

