/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.eventbus.events.colony.ColonyFlagChangedModEvent;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class ColonyFlagChangeMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"colony_flag_change", ColonyFlagChangeMessage::new);
    private final BannerPatternLayers patterns;

    public ColonyFlagChangeMessage(IColony colony, BannerPatternLayers patternList) {
        super(TYPE, colony);
        this.patterns = patternList;
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        colony.setColonyFlag(this.patterns);
        IMinecoloniesAPI.getInstance().getEventBus().post(new ColonyFlagChangedModEvent(colony));
    }

    @Override
    protected void toBytes(RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        Utils.serializeCodecMess(BannerPatternLayers.STREAM_CODEC, buf, this.patterns);
    }

    protected ColonyFlagChangeMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.patterns = (BannerPatternLayers)Utils.deserializeCodecMess(BannerPatternLayers.STREAM_CODEC, buf);
    }
}

