/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public abstract class AbstractBuildingServerMessage<T extends IBuilding>
extends AbstractColonyServerMessage {
    private final BlockPos buildingId;

    public AbstractBuildingServerMessage(PlayMessageType<?> type, IBuildingView building) {
        this(type, building.getColony().getDimension(), building.getColony().getID(), building.getID());
    }

    public AbstractBuildingServerMessage(PlayMessageType<?> type, ResourceKey<Level> dimensionId, int colonyId, BlockPos buildingId) {
        super(type, dimensionId, colonyId);
        this.buildingId = buildingId;
    }

    protected abstract void onExecute(IPayloadContext var1, ServerPlayer var2, IColony var3, T var4);

    @Override
    protected void toBytes(RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBlockPos(this.buildingId);
    }

    protected AbstractBuildingServerMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.buildingId = buf.readBlockPos();
    }

    @Override
    protected final void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        IBuilding building = colony.getBuildingManager().getBuilding(this.buildingId);
        if (building == null) {
            return;
        }
        try {
            this.onExecute(ctxIn, player, colony, building);
        }
        catch (ClassCastException e) {
            Log.getLogger().warn("onExecute called with wrong type: ", (Throwable)e);
        }
    }
}

