/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.colony.Colony;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_view", ColonyViewMessage::new, (boolean)true, (boolean)false);
    private final int colonyId;
    private boolean isNewSubscription;
    private final RegistryFriendlyByteBuf colonyBuffer;
    private final ResourceKey<Level> dim;

    public ColonyViewMessage(@NotNull Colony colony, RegistryFriendlyByteBuf buf, boolean newSubscription) {
        super(TYPE);
        this.colonyId = colony.getID();
        this.dim = colony.getDimension();
        this.colonyBuffer = buf;
        this.isNewSubscription = newSubscription;
    }

    protected ColonyViewMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonyId = buf.readInt();
        this.isNewSubscription = buf.readBoolean();
        this.dim = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.colonyBuffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.readByteArray())), buf.registryAccess());
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        this.colonyBuffer.resetReaderIndex();
        buf.writeInt(this.colonyId);
        buf.writeBoolean(this.isNewSubscription);
        buf.writeUtf(this.dim.location().toString());
        buf.writeByteArray(this.colonyBuffer.array());
    }

    protected void onExecute(IPayloadContext ctxIn, @Nullable Player player) {
        IColonyManager.getInstance().handleColonyViewMessage(this.colonyId, this.colonyBuffer, this.isNewSubscription, this.dim);
    }
}

