/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.core.client.gui.townhall.WindowTownHallDeleteAbandonColony;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class OpenDeleteAbandonColonyMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"open_delete_abandon_colony", OpenDeleteAbandonColonyMessage::new);
    private BlockPos currentTownHallPos;
    private BlockPos oldColonyPos;
    private String oldColonyName;
    private int oldColonyId;

    public OpenDeleteAbandonColonyMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(type);
        this.currentTownHallPos = buf.readBlockPos();
        this.oldColonyName = buf.readUtf(Short.MAX_VALUE);
        this.oldColonyPos = buf.readBlockPos();
        this.oldColonyId = buf.readInt();
    }

    public OpenDeleteAbandonColonyMessage(BlockPos currentTownHallPos, String oldColonyName, BlockPos oldColonyPos, int oldColonyId) {
        super(TYPE);
        this.currentTownHallPos = currentTownHallPos;
        this.oldColonyName = oldColonyName;
        this.oldColonyPos = oldColonyPos;
        this.oldColonyId = oldColonyId;
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        new WindowTownHallDeleteAbandonColony(this.currentTownHallPos, this.oldColonyName, this.oldColonyPos, this.oldColonyId).open();
    }

    public void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.currentTownHallPos);
        buf.writeUtf(this.oldColonyName);
        buf.writeBlockPos(this.oldColonyPos);
        buf.writeInt(this.oldColonyId);
    }
}

