/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.ldtteam.structurize.api.RotationMirror;
import com.minecolonies.core.client.gui.WindowBuildDecoration;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public abstract class OpenBuildWindowMessage
extends AbstractClientPlayMessage {
    protected final BlockPos pos;
    protected final String path;
    protected final String packName;
    protected final RotationMirror rotationMirror;

    protected OpenBuildWindowMessage(PlayMessageType<?> type, BlockPos pos, String packName, String path, RotationMirror rotMir) {
        super(type);
        this.pos = pos;
        this.path = path;
        this.packName = packName;
        this.rotationMirror = rotMir;
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeBlockPos(this.pos);
        buf.writeUtf(this.path);
        buf.writeUtf(this.packName);
        buf.writeByte(this.rotationMirror.ordinal());
    }

    protected OpenBuildWindowMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.pos = buf.readBlockPos();
        this.path = buf.readUtf(Short.MAX_VALUE);
        this.packName = buf.readUtf(Short.MAX_VALUE);
        this.rotationMirror = RotationMirror.values()[buf.readByte()];
    }

    public final void onExecute(IPayloadContext context, Player player) {
        new WindowBuildDecoration(this.pos, this.packName, this.path, this.rotationMirror, this::createWorkOrderMessage).open();
    }

    protected abstract AbstractServerPlayMessage createWorkOrderMessage(BlockPos var1);
}

