/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.items.IBlockOverlayItem;
import com.minecolonies.api.items.component.ModDataComponents;
import com.minecolonies.api.items.component.PermissionMode;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.items.AbstractItemMinecolonies;
import com.minecolonies.core.network.messages.server.colony.ChangeFreeToInteractBlockMessage;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemScepterPermission
extends AbstractItemMinecolonies
implements IBlockOverlayItem {
    private static final int GREEN_OVERLAY = -16711936;
    private static final int BLOCK_OVERLAY_RANGE_XZ = 32;
    private static final int BLOCK_OVERLAY_RANGE_Y = 6;

    public ItemScepterPermission(Item.Properties properties) {
        super("scepterpermission", properties.stacksTo(1).durability(2).component(ModDataComponents.PERMISSION_MODE, (Object)PermissionMode.EMPTY));
    }

    @NotNull
    private static InteractionResult handleAddBlockType(Player playerIn, Level worldIn, BlockPos pos, IColonyView iColonyView) {
        BlockState blockState = iColonyView.getWorld().getBlockState(pos);
        Block block = blockState.getBlock();
        ChangeFreeToInteractBlockMessage.MessageType type = Screen.hasControlDown() ? ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK : ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK;
        ChangeFreeToInteractBlockMessage message = new ChangeFreeToInteractBlockMessage(iColonyView, block, type);
        message.sendToServer();
        return InteractionResult.SUCCESS;
    }

    @NotNull
    private static InteractionResult handleAddLocation(Player playerIn, Level worldIn, BlockPos pos, IColonyView iColonyView) {
        ChangeFreeToInteractBlockMessage.MessageType type = Screen.hasControlDown() ? ChangeFreeToInteractBlockMessage.MessageType.REMOVE_BLOCK : ChangeFreeToInteractBlockMessage.MessageType.ADD_BLOCK;
        ChangeFreeToInteractBlockMessage message = new ChangeFreeToInteractBlockMessage(iColonyView, pos, type);
        message.sendToServer();
        return InteractionResult.SUCCESS;
    }

    @NotNull
    public InteractionResult useOn(UseOnContext ctx) {
        if (!ctx.getLevel().isClientSide) {
            return InteractionResult.SUCCESS;
        }
        ItemStack scepter = ctx.getPlayer().getItemInHand(ctx.getHand());
        IColonyView iColonyView = IColonyManager.getInstance().getClosestColonyView(ctx.getLevel(), ctx.getClickedPos());
        if (iColonyView == null) {
            return InteractionResult.FAIL;
        }
        return ItemScepterPermission.handleItemAction(scepter, ctx.getPlayer(), ctx.getLevel(), ctx.getClickedPos(), iColonyView);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(Level worldIn, Player playerIn, InteractionHand hand) {
        ItemStack scepter = playerIn.getItemInHand(hand);
        if (worldIn.isClientSide) {
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)scepter);
        }
        ItemScepterPermission.toggleItemMode(playerIn, scepter);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)scepter);
    }

    private static void toggleItemMode(Player playerIn, ItemStack stack) {
        switch (PermissionMode.readFromItemStack(stack)) {
            case BLOCK: {
                PermissionMode.LOCATION.writeToItemStack(stack);
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.setmode", MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.mode.location", new Object[0]).create()).sendTo(playerIn);
                break;
            }
            case LOCATION: {
                PermissionMode.BLOCK.writeToItemStack(stack);
                MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.setmode", MessageUtils.format("com.minecolonies.coremod.item.permissionscepter.mode.block", new Object[0]).create()).sendTo(playerIn);
            }
        }
    }

    @Override
    @NotNull
    public List<IBlockOverlayItem.OverlayBox> getOverlayBoxes(@NotNull Level world, @NotNull Player player, @NotNull ItemStack stack) {
        ArrayList<IBlockOverlayItem.OverlayBox> boxes = new ArrayList<IBlockOverlayItem.OverlayBox>();
        IColonyView colony = IColonyManager.getInstance().getClosestColonyView(world, player.blockPosition());
        if (colony == null || !colony.getPermissions().hasPermission(player, Action.EDIT_PERMISSIONS)) {
            return boxes;
        }
        switch (PermissionMode.readFromItemStack(stack)) {
            case BLOCK: {
                HashSet<Block> freeBlocks = new HashSet<Block>(colony.getFreeBlocks());
                for (BlockPos pos : BlockPos.withinManhattan((BlockPos)player.blockPosition(), (int)32, (int)6, (int)32)) {
                    if (!world.isLoaded(pos) || !freeBlocks.contains(world.getBlockState(pos).getBlock())) continue;
                    boxes.add(new IBlockOverlayItem.OverlayBox(pos, -16711936, 0.02f, true));
                }
                break;
            }
            case LOCATION: {
                for (BlockPos pos : colony.getFreePositions()) {
                    boxes.add(new IBlockOverlayItem.OverlayBox(pos, -16711936, 0.02f, true));
                }
                break;
            }
        }
        return boxes;
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flags) {
        MutableComponent mode = switch (PermissionMode.readFromItemStack(stack)) {
            default -> throw new MatchException(null, null);
            case PermissionMode.BLOCK -> Component.translatable((String)"com.minecolonies.coremod.item.permissionscepter.mode.block");
            case PermissionMode.LOCATION -> Component.translatable((String)"com.minecolonies.coremod.item.permissionscepter.mode.location");
        };
        tooltip.add((Component)Component.translatable((String)"com.minecolonies.coremod.item.permissionscepter.mode", (Object[])new Object[]{mode.withStyle(ChatFormatting.YELLOW)}));
        super.appendHoverText(stack, ctx, tooltip, flags);
    }

    @NotNull
    private static InteractionResult handleItemAction(ItemStack stack, Player playerIn, Level worldIn, BlockPos pos, IColonyView iColonyView) {
        return switch (PermissionMode.readFromItemStack(stack)) {
            default -> throw new MatchException(null, null);
            case PermissionMode.BLOCK -> ItemScepterPermission.handleAddBlockType(playerIn, worldIn, pos, iColonyView);
            case PermissionMode.LOCATION -> ItemScepterPermission.handleAddLocation(playerIn, worldIn, pos, iColonyView);
        };
    }
}

