/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults.workers;

import com.minecolonies.api.colony.jobs.ModJobs;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.core.generation.CustomRecipeProvider;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class DefaultStonemasonCraftingProvider
extends CustomRecipeProvider {
    private static final String STONEMASON = ModJobs.STONEMASON_ID.getPath();

    public DefaultStonemasonCraftingProvider(@NotNull PackOutput packOutput, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, lookupProvider);
    }

    @NotNull
    public String getName() {
        return "DefaultStonemasonCraftingProvider";
    }

    @Override
    protected void registerRecipes(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer) {
        this.convert(consumer, (ItemLike)Items.COBBLESTONE, (ItemLike)Items.SAND, (ItemLike)Items.SANDSTONE);
        this.convert(consumer, (ItemLike)Items.COBBLESTONE, (ItemLike)Items.RED_SAND, (ItemLike)Items.RED_SANDSTONE);
        this.convert(consumer, (ItemLike)Items.COBBLESTONE, (ItemLike)Items.PRISMARINE_SHARD, (ItemLike)Items.PRISMARINE);
        this.convert(consumer, (ItemLike)Items.STONE_BRICKS, (ItemLike)Items.PRISMARINE_SHARD, (ItemLike)Items.PRISMARINE_BRICKS);
        this.recipe(STONEMASON, "crafting", "end_stone").inputs(List.of(new ItemStorage(new ItemStack((ItemLike)Items.SANDSTONE, 8)), new ItemStorage(new ItemStack((ItemLike)Items.ENDER_PEARL)))).result(new ItemStack((ItemLike)Items.END_STONE, 8)).minResearchId(ResearchConstants.THE_END).build(consumer);
    }

    private void convert(@NotNull Consumer<CustomRecipeProvider.CustomRecipeBuilder> consumer, @NotNull ItemLike input1, @NotNull ItemLike input2, @NotNull ItemLike output) {
        this.recipe(STONEMASON, "crafting", BuiltInRegistries.ITEM.getKey((Object)output.asItem()).getPath()).inputs(List.of(new ItemStorage(new ItemStack(input1)), new ItemStorage(new ItemStack(input2)))).result(new ItemStack(output)).build(consumer);
    }
}

