/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.generation.defaults;

import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.util.DamageSourceKeys;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.damagesource.DamageScaling;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.EntityType;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.common.data.JsonCodecProvider;
import org.jetbrains.annotations.NotNull;

public class DefaultDamageTypeProvider
extends JsonCodecProvider<DamageType> {
    public DefaultDamageTypeProvider(@NotNull PackOutput packOutput, @NotNull ExistingFileHelper existingFileHelper, CompletableFuture<HolderLookup.Provider> lookupProvider) {
        super(packOutput, PackOutput.Target.DATA_PACK, "damage_type", PackType.SERVER_DATA, DamageType.DIRECT_CODEC, lookupProvider, "minecolonies", existingFileHelper);
    }

    protected void gather() {
        this.unconditional(DamageSourceKeys.CONSOLE.location(), DefaultDamageTypeProvider.damage("console"));
        this.unconditional(DamageSourceKeys.DEFAULT.location(), DefaultDamageTypeProvider.damage("default"));
        this.unconditional(DamageSourceKeys.DESPAWN.location(), DefaultDamageTypeProvider.damage("despawn"));
        this.unconditional(DamageSourceKeys.NETHER.location(), DefaultDamageTypeProvider.damage("nether"));
        this.unconditional(DamageSourceKeys.GUARD.location(), DefaultDamageTypeProvider.damage("entity.minecolonies.guard"));
        this.unconditional(DamageSourceKeys.GUARD_PVP.location(), DefaultDamageTypeProvider.damage("entity.minecolonies.guardpvp"));
        this.unconditional(DamageSourceKeys.SLAP.location(), DefaultDamageTypeProvider.damage("entity.minecolonies.slap"));
        this.unconditional(DamageSourceKeys.STUCK_DAMAGE.location(), DefaultDamageTypeProvider.damage("entity.minecolonies.stuckdamage"));
        this.unconditional(DamageSourceKeys.TRAINING.location(), DefaultDamageTypeProvider.damage("entity.minecolonies.training"));
        this.unconditional(DamageSourceKeys.WAKEY.location(), DefaultDamageTypeProvider.damage("entity.minecolonies.wakeywakey"));
        this.unconditional(DamageSourceKeys.AMAZON.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.AMAZON));
        this.unconditional(DamageSourceKeys.AMAZONCHIEF.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.AMAZONCHIEF));
        this.unconditional(DamageSourceKeys.AMAZONSPEARMAN.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.AMAZONSPEARMAN));
        this.unconditional(DamageSourceKeys.ARCHERBARBARIAN.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.ARCHERBARBARIAN));
        this.unconditional(DamageSourceKeys.ARCHERMUMMY.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.ARCHERMUMMY));
        this.unconditional(DamageSourceKeys.ARCHERPIRATE.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.ARCHERPIRATE));
        this.unconditional(DamageSourceKeys.BARBARIAN.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.BARBARIAN));
        this.unconditional(DamageSourceKeys.CHIEFBARBARIAN.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CHIEFBARBARIAN));
        this.unconditional(DamageSourceKeys.CHIEFPIRATE.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CHIEFPIRATE));
        this.unconditional(DamageSourceKeys.MERCENARY.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.MERCENARY));
        this.unconditional(DamageSourceKeys.MUMMY.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.MUMMY));
        this.unconditional(DamageSourceKeys.NORSEMENARCHER.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.NORSEMEN_ARCHER));
        this.unconditional(DamageSourceKeys.NORSEMENCHIEF.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.NORSEMEN_CHIEF));
        this.unconditional(DamageSourceKeys.PHARAO.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.PHARAO));
        this.unconditional(DamageSourceKeys.PIRATE.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.PIRATE));
        this.unconditional(DamageSourceKeys.SHIELDMAIDEN.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.SHIELDMAIDEN));
        this.unconditional(DamageSourceKeys.SPEAR.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.SPEAR));
        this.unconditional(DamageSourceKeys.VISITOR.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.VISITOR));
        this.unconditional(DamageSourceKeys.DROWNED_PIRATE.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.DROWNED_PIRATE));
        this.unconditional(DamageSourceKeys.DROWNED_ARCHERPIRATE.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.DROWNED_ARCHERPIRATE));
        this.unconditional(DamageSourceKeys.DROWNED_CHIEFPIRATE.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.DROWNED_CHIEFPIRATE));
        this.unconditional(DamageSourceKeys.CAMP_AMAZON.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_AMAZON));
        this.unconditional(DamageSourceKeys.CAMP_AMAZONCHIEF.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_AMAZONCHIEF));
        this.unconditional(DamageSourceKeys.CAMP_AMAZONSPEARMAN.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_AMAZONSPEARMAN));
        this.unconditional(DamageSourceKeys.CAMP_BARBARIAN.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_BARBARIAN));
        this.unconditional(DamageSourceKeys.CAMP_CHIEFBARBARIAN.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_CHIEFBARBARIAN));
        this.unconditional(DamageSourceKeys.CAMP_ARCHERBARBARIAN.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_ARCHERBARBARIAN));
        this.unconditional(DamageSourceKeys.CAMP_MUMMY.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_MUMMY));
        this.unconditional(DamageSourceKeys.CAMP_ARCHERMUMMY.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_ARCHERMUMMY));
        this.unconditional(DamageSourceKeys.CAMP_PHARAO.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_PHARAO));
        this.unconditional(DamageSourceKeys.CAMP_PIRATE.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_PIRATE));
        this.unconditional(DamageSourceKeys.CAMP_ARCHERPIRATE.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_ARCHERPIRATE));
        this.unconditional(DamageSourceKeys.CAMP_CHIEFPIRATE.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_CHIEFPIRATE));
        this.unconditional(DamageSourceKeys.CAMP_NORSEMENARCHER.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_NORSEMEN_ARCHER));
        this.unconditional(DamageSourceKeys.CAMP_NORSEMENCHIEF.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_NORSEMEN_CHIEF));
        this.unconditional(DamageSourceKeys.CAMP_SHIELDMAIDEN.location(), DefaultDamageTypeProvider.entityDamage(ModEntities.CAMP_SHIELDMAIDEN));
    }

    @NotNull
    private static DamageType entityDamage(@NotNull EntityType<?> entityType) {
        return DefaultDamageTypeProvider.damage(entityType.getDescriptionId());
    }

    @NotNull
    private static DamageType damage(@NotNull String msgId) {
        return new DamageType(msgId, DamageScaling.ALWAYS, 0.1f);
    }
}

