/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.visitor;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenColonyHandler;
import net.minecraft.world.entity.Entity;

public class VisitorColonyHandler
extends CitizenColonyHandler {
    public VisitorColonyHandler(AbstractEntityCitizen citizen) {
        super(citizen);
    }

    @Override
    public void registerWithColony(int colonyID, int citizenID) {
        if (this.registered) {
            return;
        }
        this.colonyId = colonyID;
        this.citizen.setCitizenId(citizenID);
        if (this.colonyId == 0 || this.citizen.getCivilianID() == 0) {
            this.citizen.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        IColony colony = IColonyManager.getInstance().getColonyByWorld(this.colonyId, this.citizen.level());
        if (colony == null) {
            Log.getLogger().warn(String.format("EntityCitizen '%s' unable to find Colony #%d", this.citizen.getUUID(), this.colonyId));
            this.citizen.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        this.colony = colony;
        colony.getVisitorManager().registerCivilian(this.citizen);
        this.registered = true;
    }

    @Override
    public void onCitizenRemoved() {
        if (this.citizen.getCitizenData() != null && this.registered && this.colony != null) {
            this.colony.getVisitorManager().unregisterCivilian(this.citizen);
            this.citizen.getCitizenData().setLastPosition(this.citizen.blockPosition());
        }
    }
}

