/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.pathjobs;

import com.ldtteam.domumornamentum.block.decorative.FloatingCarpetBlock;
import com.ldtteam.domumornamentum.block.decorative.PanelBlock;
import com.ldtteam.domumornamentum.block.decorative.ShingleBlock;
import com.ldtteam.domumornamentum.block.decorative.ShingleSlabBlock;
import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.pathfinding.IDynamicHeuristicNavigator;
import com.minecolonies.api.entity.pathfinding.IPathJob;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.ShapeUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import com.minecolonies.api.util.constant.PathingConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.blocks.BlockDecorationController;
import com.minecolonies.core.entity.pathfinding.MNode;
import com.minecolonies.core.entity.pathfinding.PathPointExtended;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import com.minecolonies.core.entity.pathfinding.PathingOptions;
import com.minecolonies.core.entity.pathfinding.SurfaceType;
import com.minecolonies.core.entity.pathfinding.pathjobs.IDestinationPathJob;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import com.minecolonies.core.entity.pathfinding.world.CachingBlockLookup;
import com.minecolonies.core.entity.pathfinding.world.ChunkCache;
import com.minecolonies.core.network.messages.client.SyncPathMessage;
import com.minecolonies.core.util.WorkerUtil;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Callable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractBannerBlock;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WoolCarpetBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPathJob
implements Callable<Path>,
IPathJob {
    public static final int MAX_NODES = 5000;
    @NotNull
    protected final BlockPos start;
    @NotNull
    protected final LevelReader world;
    private final Level actualWorld;
    @Nullable
    protected Mob entity = null;
    protected CachingBlockLookup cachedBlockLookup;
    protected BlockPos.MutableBlockPos tempWorldPos = new BlockPos.MutableBlockPos();
    protected final PathResult result;
    protected int maxNodes;
    private Queue<MNode> nodesToVisit;
    private final Int2ObjectOpenHashMap<MNode> nodes = new Int2ObjectOpenHashMap();
    private int totalNodesAdded = 0;
    protected int totalNodesVisited = 0;
    public int extraNodes = 0;
    protected boolean debugDrawEnabled = false;
    protected Set<MNode> debugNodesVisited = null;
    protected Set<MNode> debugNodesVisitedLater = null;
    protected Set<MNode> debugNodesNotVisited = null;
    protected Set<MNode> debugNodesPath = null;
    protected Set<MNode> debugNodesOrgPath = null;
    protected Set<MNode> debugNodesExtra = null;
    private PathingOptions pathingOptions = new PathingOptions();
    private boolean reachesDestination = false;
    private double maxCost = 0.0;
    protected double heuristicMod = 2.0;
    private MNode startNode = null;
    private int visitedLevel = 1;

    public AbstractPathJob(Level world, @NotNull BlockPos start, int range, PathResult result, @Nullable Mob entity) {
        PathNavigation pathNavigation;
        range = Math.max(10, range);
        int minX = (int)((double)start.getX() - (double)range * 1.3);
        int minZ = (int)((double)start.getZ() - (double)range * 1.3);
        int maxX = (int)((double)start.getX() + (double)range * 1.3);
        int maxZ = (int)((double)start.getZ() + (double)range * 1.3);
        this.world = new ChunkCache(world, new BlockPos(minX, 0, minZ), new BlockPos(maxX, 0, maxZ));
        this.actualWorld = world;
        this.maxNodes = Math.min(5000, range * range);
        this.nodesToVisit = new PriorityQueue<MNode>(range * 2);
        this.start = new BlockPos((Vec3i)start);
        this.cachedBlockLookup = new CachingBlockLookup(start, this.world);
        this.result = result;
        result.setJob(this);
        this.entity = entity;
        if (entity != null && (pathNavigation = entity.getNavigation()) instanceof IDynamicHeuristicNavigator) {
            IDynamicHeuristicNavigator navigator = (IDynamicHeuristicNavigator)pathNavigation;
            this.heuristicMod = 1.0 + navigator.getAvgHeuristicModifier();
        }
    }

    protected AbstractPathJob(Level actualWorld, LevelReader chunkCache, @NotNull BlockPos start, int range, PathResult result, @Nullable Mob entity) {
        PathNavigation pathNavigation;
        range = Math.max(10, range);
        this.maxNodes = Math.min(5000, range * range);
        this.nodesToVisit = new PriorityQueue<MNode>(range * 2);
        this.start = new BlockPos((Vec3i)start);
        this.world = chunkCache;
        this.cachedBlockLookup = new CachingBlockLookup(start, this.world);
        this.actualWorld = actualWorld;
        this.result = result;
        result.setJob(this);
        this.entity = entity;
        if (entity != null && (pathNavigation = entity.getNavigation()) instanceof IDynamicHeuristicNavigator) {
            IDynamicHeuristicNavigator navigator = (IDynamicHeuristicNavigator)pathNavigation;
            this.heuristicMod = 1.0 + navigator.getAvgHeuristicModifier();
        }
    }

    public AbstractPathJob(Level world, @NotNull BlockPos start, @NotNull BlockPos end, PathResult result, @Nullable Mob entity) {
        PathNavigation pathNavigation;
        int expandedRange = 32 + BlockPosUtil.distManhattan(start, end) / 2;
        int minX = Math.min(start.getX(), end.getX()) - expandedRange;
        int minZ = Math.min(start.getZ(), end.getZ()) - expandedRange;
        int maxX = Math.max(start.getX(), end.getX()) + expandedRange;
        int maxZ = Math.max(start.getZ(), end.getZ()) + expandedRange;
        this.world = new ChunkCache(world, new BlockPos(minX, 0, minZ), new BlockPos(maxX, 0, maxZ));
        int xDiff = Math.max(1, Math.abs(start.getX() - end.getX()));
        int yDiff = Math.max(1, Math.abs(start.getY() - end.getY())) * 5;
        int zDiff = Math.max(1, Math.abs(start.getZ() - end.getZ()));
        this.maxNodes = Math.min(5000, 300 + Math.max(Math.max(Math.max(2, xDiff / 10) * yDiff * zDiff, xDiff * Math.max(2, yDiff / 10) * zDiff), xDiff * yDiff * Math.max(2, zDiff / 10)));
        this.nodesToVisit = new PriorityQueue<MNode>(this.maxNodes / 4);
        this.start = new BlockPos((Vec3i)start);
        this.cachedBlockLookup = new CachingBlockLookup(start, this.world);
        this.actualWorld = world;
        this.result = result;
        result.setJob(this);
        this.entity = entity;
        if (entity != null && (pathNavigation = entity.getNavigation()) instanceof IDynamicHeuristicNavigator) {
            IDynamicHeuristicNavigator navigator = (IDynamicHeuristicNavigator)pathNavigation;
            this.heuristicMod = 1.0 + navigator.getAvgHeuristicModifier();
        }
    }

    @Override
    public final Path call() {
        try {
            return this.search();
        }
        catch (Exception e) {
            Log.getLogger().warn("Pathfinding Exception from: " + String.valueOf(this.start) + " range: " + Math.sqrt(this.maxNodes) + " entity: " + String.valueOf(this.entity) + " type: " + this.getClass().getSimpleName(), (Throwable)e);
            return null;
        }
    }

    private MNode getAndSetupStartNode() {
        MNode startNode = new MNode(null, this.start.getX(), this.start.getY(), this.start.getZ(), 0.0, this.computeHeuristic(this.start.getX(), this.start.getY(), this.start.getZ()) * this.heuristicMod);
        if (PathfindingUtils.isLadder(this.cachedBlockLookup.getBlockState(this.start.getX(), this.start.getY(), this.start.getZ()), this.pathingOptions)) {
            startNode.setLadder();
        } else if (!this.pathingOptions.canWalkUnderWater() && PathfindingUtils.isLiquid(this.cachedBlockLookup.getBlockState(this.start.below()))) {
            startNode.setSwimming();
        }
        startNode.setOnRails(this.pathingOptions.canUseRails() && this.cachedBlockLookup.getBlockState(this.start).getBlock() instanceof BaseRailBlock);
        this.nodesToVisit.offer(startNode);
        this.nodes.put(MNode.computeNodeKey(this.start.getX(), this.start.getY(), this.start.getZ()), (Object)startNode);
        ++this.totalNodesAdded;
        this.startNode = startNode;
        return startNode;
    }

    @Nullable
    protected Path search() {
        MNode bestNode = this.getAndSetupStartNode();
        double bestNodeEndScore = this.getEndNodeScore(bestNode);
        int nodesSinceEndNode = 0;
        while (!this.nodesToVisit.isEmpty()) {
            double nodeEndSCore;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            MNode node = this.nodesToVisit.poll();
            if (node.isVisited()) {
                this.visitNode(node);
                node.increaseVisited();
                continue;
            }
            ++this.totalNodesVisited;
            if ((double)this.totalNodesVisited > (double)this.maxNodes + this.maxCost * this.maxCost * 2.0 && this.stopOnNodeLimit(this.totalNodesVisited, bestNode, ++nodesSinceEndNode)) break;
            if (!this.reachesDestination && this.isAtDestination(node)) {
                bestNode = node;
                bestNodeEndScore = this.getEndNodeScore(node);
                this.result.setPathReachesDestination(true);
                this.handleDebugPathReach(bestNode);
                this.reachesDestination = true;
                if (!this.reevaluteHeuristic(bestNode, true)) break;
                this.recalcHeuristic(bestNode);
            }
            if (nodesSinceEndNode >= this.maxNodes / 2 && nodesSinceEndNode % 400 == 0 && !this.reachesDestination && this.reevaluteHeuristic(bestNode, this.reachesDestination)) {
                this.recalcHeuristic(bestNode);
                this.recalcHeuristic(node);
            }
            if (!node.isCornerNode() && (nodeEndSCore = this.getEndNodeScore(node)) < bestNodeEndScore && (!this.reachesDestination || this.isAtDestination(node))) {
                nodesSinceEndNode = 0;
                bestNode = node;
                bestNodeEndScore = nodeEndSCore;
            }
            if (this.reachesDestination && node.getScore() > bestNode.getScore()) {
                if (!this.reevaluteHeuristic(bestNode, this.reachesDestination)) break;
                this.recalcHeuristic(bestNode);
                this.recalcHeuristic(node);
            }
            this.handleDebugOptions(node);
            this.visitNode(node);
            node.increaseVisited();
        }
        if (this.extraNodes > 0 && this.reachesDestination) {
            this.visitNode(bestNode);
            if (!this.nodesToVisit.isEmpty()) {
                Queue<MNode> original = this.nodesToVisit;
                this.nodesToVisit = new PriorityQueue<MNode>(this.nodesToVisit.size(), (a, b) -> {
                    if (a.getHeuristic() < b.getHeuristic()) {
                        return -1;
                    }
                    if (a.getHeuristic() > b.getHeuristic()) {
                        return 1;
                    }
                    return a.getCounterAdded() - b.getCounterAdded();
                });
                this.nodesToVisit.addAll(original);
                while (!this.nodesToVisit.isEmpty()) {
                    if (Thread.currentThread().isInterrupted()) {
                        return null;
                    }
                    MNode node = this.nodesToVisit.poll();
                    if (node.isVisited()) {
                        this.visitNode(node);
                        continue;
                    }
                    this.handleDebugExtraNode(node);
                    double nodeEndSCore = this.getEndNodeScore(node);
                    if (nodeEndSCore < bestNodeEndScore && (!this.reachesDestination || this.isAtDestination(node))) {
                        bestNode = node;
                        bestNodeEndScore = nodeEndSCore;
                    }
                    if (this.extraNodes > 0) {
                        --this.extraNodes;
                        if (this.extraNodes == 0) break;
                    }
                    this.visitNode(node);
                }
            }
        }
        return this.finalizePath(bestNode);
    }

    protected boolean stopOnNodeLimit(int totalNodesVisited, MNode bestNode, int nodesSinceEndNode) {
        return true;
    }

    private boolean reevaluteHeuristic(MNode node, boolean reaches) {
        if (this.startNode.getHeuristic() < 0.01) {
            return false;
        }
        double costPerEstimation = node.getCost() / this.startNode.getHeuristic();
        if (!reaches) {
            AbstractPathJob abstractPathJob;
            if (node.parent != null && (abstractPathJob = this) instanceof IDestinationPathJob) {
                IDestinationPathJob job = (IDestinationPathJob)((Object)abstractPathJob);
                double heuristicCostEstimationPerDist = this.startNode.getHeuristic() / Math.max(1.0, BlockPosUtil.dist(job.getDestination(), this.start));
                int dist = 0;
                MNode currNode = node;
                while (currNode.parent != null) {
                    currNode = currNode.parent;
                    ++dist;
                }
                double realCostPerDist = node.getCost() / (double)dist;
                costPerEstimation = realCostPerDist / heuristicCostEstimationPerDist;
            } else {
                int count = 0;
                costPerEstimation = 0.0;
                double lowestAroundStart = Double.MAX_VALUE;
                lowestAroundStart = Math.min(lowestAroundStart, this.computeHeuristic(this.startNode.x + 1, this.startNode.y, this.startNode.z) * this.heuristicMod);
                lowestAroundStart = Math.min(lowestAroundStart, this.computeHeuristic(this.startNode.x - 1, this.startNode.y, this.startNode.z) * this.heuristicMod);
                lowestAroundStart = Math.min(lowestAroundStart, this.computeHeuristic(this.startNode.x, this.startNode.y, this.startNode.z + 1) * this.heuristicMod);
                lowestAroundStart = Math.min(lowestAroundStart, this.computeHeuristic(this.startNode.x, this.startNode.y, this.startNode.z - 1) * this.heuristicMod);
                lowestAroundStart = Math.min(lowestAroundStart, this.computeHeuristic(this.startNode.x, this.startNode.y + 1, this.startNode.z) * this.heuristicMod);
                lowestAroundStart = Math.min(lowestAroundStart, this.computeHeuristic(this.startNode.x, this.startNode.y - 1, this.startNode.z) * this.heuristicMod);
                double heuristicPerDist = this.startNode.getHeuristic() - lowestAroundStart;
                if (heuristicPerDist <= 0.0) {
                    return false;
                }
                for (MNode cur : this.nodesToVisit) {
                    if (cur.getHeuristic() >= this.startNode.getHeuristic() || cur.isVisited()) continue;
                    costPerEstimation += cur.getCost() / ((double)BlockPosUtil.distManhattan(cur.x, cur.y, cur.z, this.startNode.x, this.startNode.y, this.startNode.z) * heuristicPerDist);
                    if (++count != 20) continue;
                    break;
                }
                if (count == 0) {
                    return false;
                }
                costPerEstimation /= (double)count;
            }
        }
        if (costPerEstimation <= 0.0) {
            return false;
        }
        if (costPerEstimation < 0.9 || costPerEstimation > 1.2 && !reaches) {
            PathNavigation count;
            costPerEstimation *= costPerEstimation < 1.0 ? 0.9 : 1.1;
            if (reaches && this.entity != null && (count = this.entity.getNavigation()) instanceof IDynamicHeuristicNavigator) {
                IDynamicHeuristicNavigator navigator = (IDynamicHeuristicNavigator)count;
                double foundPathCostPerDist = node.getCost() / (double)Math.max(1, BlockPosUtil.distManhattan(this.start, node.x, node.y, node.z));
                if (foundPathCostPerDist > navigator.getAvgHeuristicModifier()) {
                    double modifier = Math.min(0.8, Math.max(0.3, navigator.getAvgHeuristicModifier() / foundPathCostPerDist));
                    costPerEstimation *= modifier;
                }
            }
            if (reaches) {
                this.heuristicMod *= costPerEstimation;
            } else {
                double currentMod = this.heuristicMod;
                this.heuristicMod -= this.heuristicMod / 2.0;
                this.heuristicMod += currentMod * costPerEstimation / 2.0;
            }
            ArrayList<MNode> nodes = new ArrayList<MNode>(this.nodesToVisit);
            this.nodesToVisit.clear();
            for (MNode recalc : nodes) {
                this.recalcHeuristic(recalc);
                this.nodesToVisit.offer(recalc);
            }
            this.recalcHeuristic(this.startNode);
            this.recalcHeuristic(node);
            ++this.visitedLevel;
            return true;
        }
        return false;
    }

    private void recalcHeuristic(MNode node) {
        node.setHeuristic(this.computeHeuristic(node.x, node.y, node.z) * this.heuristicMod);
    }

    protected void visitNode(MNode node) {
        this.cachedBlockLookup.resetToNextPos(node.x, node.y, node.z);
        int dX = 0;
        int dY = 0;
        int dZ = 0;
        if (node.parent != null) {
            dX = node.x - node.parent.x;
            dY = node.y - node.parent.y;
            dZ = node.z - node.parent.z;
        }
        if (node.isLadder() || node.isVisited()) {
            this.exploreInDirection(node, 0, 1, 0);
            this.exploreInDirection(node, 0, -1, 0);
        } else {
            if (node.isCornerNode() && (node.parent == null || dX != 0 || dY != 1 || dZ != 0)) {
                this.exploreInDirection(node, 0, -1, 0);
                return;
            }
            if (!node.isSwimming() && this.isPassable(node.x, node.y - 1, node.z, false, node.parent)) {
                this.exploreInDirection(node, 0, -1, 0);
            }
        }
        if (dZ <= 0) {
            this.exploreInDirection(node, 0, 0, -1);
        }
        if (dX >= 0) {
            this.exploreInDirection(node, 1, 0, 0);
        }
        if (dZ >= 0) {
            this.exploreInDirection(node, 0, 0, 1);
        }
        if (dX <= 0) {
            this.exploreInDirection(node, -1, 0, 0);
        }
    }

    protected final void exploreInDirection(MNode node, int dX, int dY, int dZ) {
        int nodeKey;
        MNode nextNode;
        Block origin;
        Block target;
        int nextX = node.x + dX;
        int nextY = node.y + dY;
        int nextZ = node.z + dZ;
        int newY = node.isVisited() ? ((target = this.cachedBlockLookup.getBlockState(nextX, nextY, nextZ).getBlock()) instanceof PanelBlock || target instanceof TrapDoorBlock ? this.getGroundHeight(node, nextX, nextY, nextZ) : ((origin = this.cachedBlockLookup.getBlockState(node.x, node.y, node.z).getBlock()) instanceof PanelBlock || origin instanceof TrapDoorBlock ? this.getGroundHeight(node, nextX, nextY, nextZ) : nextY)) : this.getGroundHeight(node, nextX, nextY, nextZ);
        if (newY < this.world.getMinBuildHeight()) {
            return;
        }
        boolean corner = false;
        if (nextY != newY) {
            if (node.isCornerNode() && (dX != 0 || dZ != 0)) {
                return;
            }
            if (!(node.isCornerNode() || newY - node.y <= 0 || node.parent != null && BlockPosUtil.equals(node.parent.x, node.parent.y, node.parent.z, node.x, node.y + newY - nextY, node.z))) {
                nextX = node.x;
                nextY = node.y + (newY - nextY);
                nextZ = node.z;
                corner = true;
            } else if (!(node.isCornerNode() || newY - node.y >= 0 || dX == 0 && dZ == 0 || node.parent != null && node.x == node.parent.x && node.y - 1 == node.parent.y && node.z == node.parent.z)) {
                nextX = node.x + dX;
                nextY = node.y;
                nextZ = node.z + dZ;
                corner = true;
            } else {
                dX = 0;
                dY = newY - nextY;
                dZ = 0;
                nextY = newY;
            }
        }
        if ((nextNode = (MNode)this.nodes.get(nodeKey = MNode.computeNodeKey(nextX, nextY, nextZ))) != null && nextNode.isCornerNode()) {
            if (node.isCornerNode()) {
                return;
            }
            if (corner && nextNode.parent != null && (nextNode.parent.x != nextX || nextNode.parent.z != nextZ)) {
                nextX = node.x + dX;
                nextY = newY;
                nextZ = node.z + dZ;
                nextNode = (MNode)this.nodes.get(MNode.computeNodeKey(nextX, nextY, nextZ));
                corner = false;
            } else {
                corner = true;
            }
        }
        if (node.isVisited() && (nextNode == null || nextNode == node.parent)) {
            return;
        }
        BlockState aboveState = this.cachedBlockLookup.getBlockState(nextX, nextY + 1, nextZ);
        BlockState state = this.cachedBlockLookup.getBlockState(nextX, nextY, nextZ);
        BlockState belowState = this.cachedBlockLookup.getBlockState(nextX, nextY - 1, nextZ);
        boolean isSwimming = this.calculateSwimming(belowState, state, aboveState, nextNode);
        if (isSwimming && !this.pathingOptions.canSwim()) {
            return;
        }
        boolean swimStart = isSwimming && !node.isSwimming();
        boolean onRoad = WorkerUtil.isPathBlock(belowState.getBlock());
        boolean onRails = this.pathingOptions.canUseRails() && (corner ? belowState : state).getBlock() instanceof BaseRailBlock;
        boolean railsExit = !onRails && node != null && node.isOnRails();
        boolean ladder = PathfindingUtils.isLadder(state, this.pathingOptions);
        boolean isDiving = isSwimming && PathfindingUtils.isWater((BlockGetter)this.world, null, aboveState, null);
        double nextCost = 0.0;
        if (!corner) {
            MNode costFrom = node;
            dY = nextY - node.y;
            if (node.isCornerNode() && node.parent != null) {
                dX = nextX - node.parent.x;
                dY = nextY - node.parent.y;
                dZ = nextZ - node.parent.z;
                costFrom = node.parent;
            }
            nextCost = this.computeCost(costFrom, dX, dY, dZ, isSwimming, onRoad, isDiving, onRails, railsExit, swimStart, ladder, state, belowState, nextX, nextY, nextZ);
            if ((nextCost = this.modifyCost(nextCost, costFrom, swimStart, isSwimming, nextX, nextY, nextZ, state, belowState)) > this.maxCost) {
                this.maxCost = Math.min(25.0, Math.ceil(nextCost));
            }
        }
        double heuristic = this.computeHeuristic(nextX, nextY, nextZ) * this.heuristicMod;
        double cost = node.getCost() + nextCost;
        if (nextNode == null) {
            nextNode = this.createNode(node, nextX, nextY, nextZ, nodeKey, heuristic, cost);
            nextNode.setOnRails(onRails);
            nextNode.setCornerNode(corner);
            if (isSwimming) {
                nextNode.setSwimming();
            }
            if (ladder) {
                nextNode.setLadder();
            }
            this.nodesToVisit.offer(nextNode);
        } else {
            this.updateNode(node, nextNode, heuristic, cost);
        }
    }

    @NotNull
    private MNode createNode(MNode parent, int x, int y, int z, int nodeKey, double heuristic, double cost) {
        MNode node = new MNode(parent, x, y, z, cost, heuristic);
        this.nodes.put(nodeKey, (Object)node);
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.add(node);
        }
        ++this.totalNodesAdded;
        node.setCounterAdded(this.totalNodesAdded);
        return node;
    }

    private void updateNode(@NotNull MNode node, @NotNull MNode nextNode, double heuristic, double cost) {
        if (cost >= nextNode.getCost() || nextNode.getVisitedCount() > this.visitedLevel) {
            return;
        }
        this.nodesToVisit.remove(nextNode);
        nextNode.parent = node;
        nextNode.setCost(cost);
        nextNode.setHeuristic(heuristic);
        this.nodesToVisit.offer(nextNode);
    }

    protected abstract double computeHeuristic(int var1, int var2, int var3);

    protected abstract boolean isAtDestination(MNode var1);

    protected double getEndNodeScore(MNode n) {
        return n.getHeuristic();
    }

    protected double computeCost(MNode parent, int dX, int dY, int dZ, boolean isSwimming, boolean onPath, boolean isDiving, boolean onRails, boolean railsExit, boolean swimStart, boolean ladder, BlockState state, BlockState below, int x, int y, int z) {
        double cost = 1.0;
        if (this.pathingOptions.randomnessFactor > 0.0) {
            cost += ColonyConstants.rand.nextDouble() * this.pathingOptions.randomnessFactor;
        }
        if (!isSwimming) {
            if (onPath) {
                cost *= this.pathingOptions.onPathCost;
            }
            if (onRails) {
                cost *= this.pathingOptions.onRailCost;
            }
        }
        if (state.getBlock() == Blocks.CAVE_AIR) {
            cost += this.pathingOptions.caveAirCost;
        }
        if (!(isDiving || dY == 0 || ladder && parent.isLadder() || Math.abs(dY) == 1 && below.is(BlockTags.STAIRS))) {
            if (dY > 0) {
                cost += this.pathingOptions.jumpCost;
            } else if (this.pathingOptions.dropCost != 0.0) {
                cost += this.pathingOptions.dropCost * (double)Math.abs(dY * dY * dY);
            }
        }
        if (state.hasProperty((Property)BlockStateProperties.OPEN) && !(state.getBlock() instanceof PanelBlock)) {
            cost += this.pathingOptions.traverseToggleAbleCost;
        } else if (!onPath && ShapeUtil.hasCollision(this.cachedBlockLookup, (BlockPos)this.tempWorldPos.set(x, y, z), state)) {
            cost += this.pathingOptions.walkInShapesCost;
        }
        if (below.getBlock() instanceof ShingleBlock || below.getBlock() instanceof ShingleSlabBlock) {
            cost += 3.0;
        }
        if (railsExit) {
            cost += this.pathingOptions.railsExitCost;
        }
        if (!isDiving && ladder && !parent.isLadder() && !(state.getBlock() instanceof LadderBlock)) {
            cost += this.pathingOptions.nonLadderClimbableCost;
        }
        if (isSwimming) {
            cost = swimStart ? (cost += this.pathingOptions.swimCostEnter) : (cost += this.pathingOptions.swimCost);
            if (isDiving) {
                cost += this.pathingOptions.divingCost;
            }
        }
        return cost;
    }

    protected double modifyCost(double cost, MNode parent, boolean swimstart, boolean swimming, int x, int y, int z, BlockState state, BlockState below) {
        return cost;
    }

    @NotNull
    private Path finalizePath(MNode targetNode) {
        int pathLength = 1;
        int railsLength = 0;
        MNode node = targetNode;
        while (node.parent != null) {
            ++pathLength;
            if (node.isOnRails()) {
                ++railsLength;
            }
            node = node.parent;
        }
        Node[] points = new Node[pathLength];
        points[0] = new PathPointExtended(new BlockPos(node.x, node.y, node.z));
        if (this.debugDrawEnabled) {
            this.addPathNodeToDebug(node);
        }
        MNode nextInPath = null;
        PathPointExtended next = null;
        node = targetNode;
        while (node.parent != null) {
            if (this.debugDrawEnabled) {
                this.addPathNodeToDebug(node);
            }
            --pathLength;
            BlockPos pos = new BlockPos(node.x, node.y, node.z);
            if (node.isSwimming()) {
                pos.offset((Vec3i)PathingConstants.BLOCKPOS_DOWN);
            }
            PathPointExtended p = new PathPointExtended(pos);
            if (railsLength >= (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).minimumRailsToPath.get()) {
                PathPointExtended point;
                p.setOnRails(node.isOnRails());
                if (p.isOnRails() && (!node.parent.isOnRails() || node.parent.parent == null)) {
                    p.setRailsEntry();
                } else if (p.isOnRails() && points.length > pathLength + 1 && !(point = (PathPointExtended)points[pathLength + 1]).isOnRails()) {
                    point.setRailsExit();
                }
            }
            if (node.isLadder()) {
                p.setOnLadder(true);
                if (nextInPath != null && nextInPath.y > pos.getY()) {
                    PathfindingUtils.setLadderFacing(this.world, pos, p);
                }
            }
            if (next != null) {
                next.cameFrom = p;
            }
            next = p;
            points[pathLength] = p;
            nextInPath = node;
            node = node.parent;
        }
        this.doDebugPrinting(points);
        if (points.length > 1) {
            this.result.costPerDist = targetNode.getCost() / (double)BlockPosUtil.distManhattan(this.start, targetNode.x, targetNode.y, targetNode.z);
        }
        this.result.searchedNodes = this.totalNodesVisited;
        return new Path(Arrays.asList(points), new BlockPos(targetNode.x, targetNode.y, targetNode.z), this.reachesDestination);
    }

    protected int getGroundHeight(MNode node, int x, int y, int z) {
        if (!this.pathingOptions.canWalkUnderWater() && PathfindingUtils.isLiquid(this.cachedBlockLookup.getBlockState(x, y + 1, z))) {
            return Integer.MIN_VALUE;
        }
        if (this.checkHeadBlock(node, x, y, z)) {
            return this.handleTargetNotPassable(node, x, y + 1, z, this.cachedBlockLookup.getBlockState(x, y + 1, z));
        }
        BlockState target = this.cachedBlockLookup.getBlockState(x, y, z);
        if (!this.isPassable(target, x, y, z, node, false)) {
            return this.handleTargetNotPassable(node, x, y, z, target);
        }
        BlockState below = this.cachedBlockLookup.getBlockState(x, y - 1, z);
        SurfaceType walkability = SurfaceType.getSurfaceType((BlockGetter)this.world, below, (BlockPos)this.tempWorldPos.set(x, y - 1, z), this.pathingOptions);
        if (walkability == SurfaceType.WALKABLE) {
            return y;
        }
        if (walkability == SurfaceType.NOT_PASSABLE) {
            return Integer.MIN_VALUE;
        }
        return this.handleNotStanding(node, x, y, z, below);
    }

    private boolean checkHeadBlock(@Nullable MNode parent, int x, int y, int z) {
        VoxelShape bb2;
        if (!this.canLeaveBlock(x, y + 1, z, parent, true)) {
            return true;
        }
        if (!this.isPassable(x, y + 1, z, true, parent)) {
            VoxelShape bb1 = this.cachedBlockLookup.getBlockState(x, y - 1, z).getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y - 1, z));
            bb2 = this.cachedBlockLookup.getBlockState(x, y + 1, z).getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y + 1, z));
            if ((double)(y + 1) + ShapeUtil.getStartY(bb2, 1.0) - ((double)(y - 1) + ShapeUtil.getEndY(bb1, 0.0)) < 2.0) {
                return true;
            }
            if (parent != null) {
                VoxelShape bb3 = this.cachedBlockLookup.getBlockState(parent.x, parent.y - 1, parent.z).getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(parent.x, parent.y - 1, parent.z));
                if ((double)(y + 1) + ShapeUtil.getStartY(bb2, 1.0) - ((double)(parent.y - 1) + ShapeUtil.getEndY(bb3, 0.0)) < 1.75) {
                    return true;
                }
            }
        }
        if (parent != null) {
            BlockState belowState = this.cachedBlockLookup.getBlockState(x, y - 1, z);
            bb2 = this.cachedBlockLookup.getBlockState(x, y + 1, z).getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y + 1, z));
            VoxelShape bb = this.cachedBlockLookup.getBlockState(x, y, z).getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y, z));
            if ((double)(y + 1) + ShapeUtil.getStartY(bb2, 1.0) - ((double)y + ShapeUtil.getEndY(bb, 0.0)) >= 2.0) {
                return false;
            }
            return parent.isSwimming() && PathfindingUtils.isLiquid(belowState) && !this.isPassable(x, y, z, false, parent);
        }
        return false;
    }

    protected boolean isPassable(@NotNull BlockState block, int x, int y, int z, MNode parent, boolean head) {
        if (!this.canLeaveBlock(x, y, z, parent, head)) {
            return false;
        }
        if (!block.isAir()) {
            PathType pathType;
            VoxelShape shape = block.getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y, z));
            if (!this.pathingOptions.canPassDanger() && ShapeUtil.max(shape, Direction.Axis.Y) < 0.5 && PathfindingUtils.isDangerous(this.cachedBlockLookup.getBlockState(x, y - 1, z))) {
                return false;
            }
            if (block.blocksMotion() && !ShapeUtil.isEmpty(shape) && !(ShapeUtil.max(shape, Direction.Axis.Y) <= 0.1)) {
                if (block.getBlock() instanceof TrapDoorBlock || block.getBlock() instanceof PanelBlock) {
                    int parentY;
                    int n = parentY = parent == null ? this.start.getY() : parent.y;
                    if (head) {
                        ++parentY;
                    }
                    int dY = y - parentY;
                    Direction direction = BlockPosUtil.getXZFacing(parent == null ? this.start.getX() : parent.x, parent == null ? this.start.getZ() : parent.z, x, z);
                    Direction facing = (Direction)block.getValue((Property)TrapDoorBlock.FACING);
                    if (block.getBlock() instanceof PanelBlock && !((Boolean)block.getValue((Property)PanelBlock.OPEN)).booleanValue()) {
                        if (dY == 0) {
                            return head && block.getValue((Property)PanelBlock.HALF) == Half.TOP;
                        }
                        if (head && dY == 1 && block.getValue((Property)PanelBlock.HALF) == Half.TOP) {
                            return true;
                        }
                        return !head && dY == -1 && block.getValue((Property)PanelBlock.HALF) == Half.BOTTOM;
                    }
                    if (direction == facing.getOpposite()) {
                        return true;
                    }
                    return direction != facing;
                }
                return this.pathingOptions.canEnterDoors() && (block.getBlock() instanceof DoorBlock || block.getBlock() instanceof FenceGateBlock) || block.getBlock() instanceof AbstractBlockMinecoloniesConstructionTape || block.getBlock() instanceof PressurePlateBlock || block.getBlock() instanceof BlockDecorationController || block.getBlock() instanceof SignBlock || block.getBlock() instanceof AbstractBannerBlock || !block.getBlock().properties().hasCollision;
            }
            if (!this.pathingOptions.canPassDanger() && PathfindingUtils.isDangerous(block)) {
                return false;
            }
            if (PathfindingUtils.isLadder(block, this.pathingOptions)) {
                return true;
            }
            return (ShapeUtil.isEmpty(shape) || ShapeUtil.max(shape, Direction.Axis.Y) <= 0.1 && !PathfindingUtils.isLiquid(block) && (block.getBlock() != Blocks.SNOW || (Integer)block.getValue((Property)SnowLayerBlock.LAYERS) == 1)) && ((pathType = block.getBlockPathType((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y, z), this.entity)) == null || pathType.getMalus() < 0.0f);
        }
        return true;
    }

    protected boolean isPassable(int x, int y, int z, boolean head, MNode parent) {
        BlockState state = this.cachedBlockLookup.getBlockState(x, y, z);
        VoxelShape shape = state.getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y, z));
        if (ShapeUtil.isEmpty(shape) || ShapeUtil.max(shape, Direction.Axis.Y) <= 0.1) {
            return !head || !(state.getBlock() instanceof WoolCarpetBlock) && !(state.getBlock() instanceof FloatingCarpetBlock) || PathfindingUtils.isLadder(state, this.pathingOptions);
        }
        return this.isPassable(state, x, y, z, parent, head);
    }

    private int handleTargetNotPassable(@Nullable MNode parent, int x, int y, int z, @NotNull BlockState target) {
        VoxelShape bb2;
        VoxelShape bb1;
        boolean canJump;
        boolean bl = canJump = parent != null && !parent.isLadder() && !parent.isSwimming();
        if (!canJump || SurfaceType.getSurfaceType((BlockGetter)this.world, target, (BlockPos)this.tempWorldPos.set(x, y, z), this.getPathingOptions()) != SurfaceType.WALKABLE) {
            return Integer.MIN_VALUE;
        }
        if (!this.isPassable(x, y + 2, z, true, parent)) {
            bb1 = this.cachedBlockLookup.getBlockState(x, y, z).getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y, z));
            bb2 = this.cachedBlockLookup.getBlockState(x, y + 2, z).getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y + 2, z));
            if ((double)(y + 2) + ShapeUtil.getStartY(bb2, 1.0) - ((double)y + ShapeUtil.getEndY(bb1, 0.0)) < 2.0) {
                return Integer.MIN_VALUE;
            }
        }
        if (!this.canLeaveBlock(x, y + 2, z, parent, true)) {
            return Integer.MIN_VALUE;
        }
        if (!this.isPassable(parent.x, parent.y + 2, parent.z, true, parent)) {
            bb1 = this.cachedBlockLookup.getBlockState(x, y, z).getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y, z));
            bb2 = this.cachedBlockLookup.getBlockState(parent.x, parent.y + 2, parent.z).getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(parent.x, parent.y + 2, parent.z));
            if ((double)(parent.y + 2) + ShapeUtil.getStartY(bb2, 1.0) - ((double)y + ShapeUtil.getEndY(bb1, 0.0)) < 2.0) {
                return Integer.MIN_VALUE;
            }
        }
        BlockState parentBelow = this.cachedBlockLookup.getBlockState(parent.x, parent.y - 1, parent.z);
        VoxelShape parentBB = parentBelow.getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(parent.x, parent.y - 1, parent.z));
        double parentY = ShapeUtil.max(parentBB, Direction.Axis.Y);
        double parentMaxY = parentY + (double)parent.y - 1.0;
        double targetMaxY = ShapeUtil.max(target.getCollisionShape((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y, z)), Direction.Axis.Y) + (double)y;
        if (targetMaxY - parentMaxY < 1.3) {
            return y + 1;
        }
        if (target.is(BlockTags.STAIRS) && parentY - 0.5 < 1.3 && target.getValue((Property)StairBlock.HALF) == Half.BOTTOM && BlockPosUtil.getXZFacing(parent.x, parent.z, x, z) == target.getValue((Property)StairBlock.FACING)) {
            return y + 1;
        }
        return Integer.MIN_VALUE;
    }

    private int handleNotStanding(@Nullable MNode parent, int x, int y, int z, @NotNull BlockState below) {
        boolean isSwimming;
        boolean bl = isSwimming = parent != null && parent.isSwimming();
        if (!this.pathingOptions.canWalkUnderWater() && PathfindingUtils.isLiquid(below)) {
            return this.handleInLiquid(x, y, z, below, isSwimming);
        }
        if (PathfindingUtils.isLadder(below, this.pathingOptions)) {
            return y;
        }
        return this.checkDrop(parent, x, y, z, isSwimming);
    }

    private int checkDrop(@Nullable MNode parent, int x, int y, int z, boolean isSwimming) {
        boolean canDrop;
        boolean bl = canDrop = parent != null && !parent.isLadder();
        if (!canDrop || (parent.x != x || parent.z != z) && this.isPassable(parent.x, parent.y - 1, parent.z, false, parent) && SurfaceType.getSurfaceType((BlockGetter)this.world, this.cachedBlockLookup.getBlockState(parent.x, parent.y - 1, parent.z), (BlockPos)this.tempWorldPos.set(parent.x, parent.y - 1, parent.z), this.getPathingOptions()) == SurfaceType.DROPABLE) {
            return Integer.MIN_VALUE;
        }
        for (int i = 2; i <= (this.pathingOptions.canDrop ? 10 : 2); ++i) {
            BlockState below = this.cachedBlockLookup.getBlockState(x, y - i, z);
            if (!this.canLeaveBlock(x, y - 1, z, x, y, z, false)) {
                return Integer.MIN_VALUE;
            }
            if (SurfaceType.getSurfaceType((BlockGetter)this.world, below, (BlockPos)this.tempWorldPos.set(x, y - i, z), this.getPathingOptions()) == SurfaceType.WALKABLE) {
                return y - i + 1;
            }
            if (below.isAir()) continue;
            return Integer.MIN_VALUE;
        }
        return Integer.MIN_VALUE;
    }

    private int handleInLiquid(int x, int y, int z, @NotNull BlockState below, boolean isSwimming) {
        if (isSwimming) {
            return y;
        }
        if (this.pathingOptions.canSwim() && PathfindingUtils.isWater((BlockGetter)this.world, (BlockPos)this.tempWorldPos.set(x, y - 1, z))) {
            return y;
        }
        return Integer.MIN_VALUE;
    }

    private boolean canLeaveBlock(int x, int y, int z, MNode parent, boolean head) {
        int parentX = parent == null ? this.start.getX() : parent.x;
        int parentY = parent == null ? this.start.getY() : parent.y;
        int parentZ = parent == null ? this.start.getZ() : parent.z;
        return this.canLeaveBlock(x, y, z, parentX, head ? parentY + 1 : parentY, parentZ, head);
    }

    private boolean canLeaveBlock(int x, int y, int z, int parentX, int parentY, int parentZ, boolean head) {
        int dY = y - parentY;
        BlockState parentBlockState = this.cachedBlockLookup.getBlockState(parentX, parentY, parentZ);
        Block parentBlock = parentBlockState.getBlock();
        if (parentBlock instanceof TrapDoorBlock || parentBlock instanceof PanelBlock) {
            Direction facing;
            Direction direction;
            if (!((Boolean)parentBlockState.getValue((Property)TrapDoorBlock.OPEN)).booleanValue()) {
                if (dY != 0) {
                    if (parentBlock instanceof TrapDoorBlock) {
                        return true;
                    }
                    return head && parentBlockState.getValue((Property)PanelBlock.HALF) == Half.TOP && dY < 0 || !head && parentBlockState.getValue((Property)PanelBlock.HALF) == Half.BOTTOM && dY > 0;
                }
                return true;
            }
            if ((x - parentX != 0 || z - parentZ != 0) && (direction = BlockPosUtil.getXZFacing(parentX, parentZ, x, z)) == (facing = (Direction)parentBlockState.getValue((Property)TrapDoorBlock.FACING)).getOpposite()) {
                return false;
            }
        } else if (parentBlock instanceof FloatingCarpetBlock) {
            if (dY < 0) {
                return head;
            }
            if (dY > 0) {
                return !head;
            }
        }
        return true;
    }

    private boolean calculateSwimming(BlockState below, BlockState state, BlockState above, @Nullable MNode node) {
        if (node != null) {
            return node.isSwimming();
        }
        return PathfindingUtils.isWater(this.cachedBlockLookup, null, below, null) || PathfindingUtils.isWater(this.cachedBlockLookup, null, state, null) || PathfindingUtils.isWater(this.cachedBlockLookup, null, above, null);
    }

    public void initDebug() {
        if (!this.debugDrawEnabled) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<MNode>();
            this.debugNodesVisitedLater = new HashSet<MNode>();
            this.debugNodesNotVisited = new HashSet<MNode>();
            this.debugNodesPath = new HashSet<MNode>();
            this.debugNodesOrgPath = new HashSet<MNode>();
            this.debugNodesExtra = new HashSet<MNode>();
        }
    }

    protected void handleDebugOptions(MNode node) {
        if (this.debugDrawEnabled) {
            this.addNodeToDebug(node);
            if ((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).pathfindingDebugVerbosity.get() == 2) {
                Log.getLogger().info(String.format("Examining node [%d,%d,%d] ; c=%f ; h=%f", node.x, node.y, node.z, node.getCost(), node.getHeuristic()));
            }
        }
    }

    private void handleDebugExtraNode(MNode node) {
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.remove(node);
            this.debugNodesExtra.add(node);
        }
    }

    private void handleDebugPathReach(MNode bestNode) {
        if (this.debugDrawEnabled) {
            this.debugNodesOrgPath.add(bestNode);
            MNode currentNode = bestNode;
            while (currentNode.parent != null) {
                currentNode = currentNode.parent;
                this.debugNodesOrgPath.add(currentNode);
            }
        }
    }

    private void doDebugPrinting(@NotNull Node[] points) {
        if (this.debugDrawEnabled && (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).pathfindingDebugVerbosity.get() > 0) {
            Log.getLogger().info("Path found:");
            for (Node p : points) {
                Log.getLogger().info(String.format("Step: [%d,%d,%d]", p.x, p.y, p.z));
            }
            Log.getLogger().info(String.format("Total Nodes Visited %d / %d", this.totalNodesVisited, this.totalNodesAdded));
        }
    }

    private void addNodeToDebug(MNode currentNode) {
        if (this.debugNodesOrgPath.contains(currentNode)) {
            return;
        }
        this.debugNodesNotVisited.remove(currentNode);
        this.debugNodesVisited.add(currentNode);
        if (this.reachesDestination) {
            this.debugNodesVisited.remove(currentNode);
            this.debugNodesVisitedLater.add(currentNode);
        }
    }

    private void addPathNodeToDebug(MNode node) {
        this.debugNodesVisited.remove(node);
        this.debugNodesPath.add(node);
    }

    public void syncDebug(List<ServerPlayer> debugWatchers) {
        if (this.debugDrawEnabled) {
            SyncPathMessage message = new SyncPathMessage(this.debugNodesVisited, this.debugNodesNotVisited, this.debugNodesPath, this.debugNodesVisitedLater, this.debugNodesOrgPath, this.debugNodesExtra);
            for (ServerPlayer player : debugWatchers) {
                message.sendToPlayer(player);
            }
        }
    }

    @Override
    public PathResult getResult() {
        return this.result;
    }

    public void setPathingOptions(PathingOptions pathingOptions) {
        this.pathingOptions.importFrom(pathingOptions);
    }

    @Override
    public PathingOptions getPathingOptions() {
        return this.pathingOptions;
    }

    @Override
    public Mob getEntity() {
        return this.entity;
    }

    @Override
    public Level getActualWorld() {
        return this.actualWorld;
    }

    @Override
    public BlockPos getStart() {
        return this.start;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " start:" + String.valueOf(this.start) + " entity:" + String.valueOf(this.entity) + " maxNodes:" + this.maxNodes + " totalNodesVisited:" + this.totalNodesVisited + " h-rebalances:" + (this.visitedLevel - 1) + " reaches:" + this.reachesDestination;
    }
}

