/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.workers.util;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.placement.AbstractBlueprintIteratorWrapper;
import com.ldtteam.structurize.placement.StructureIterators;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.util.BlueprintPositionInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

public class LayerBlueprintIterator
extends AbstractBlueprintIteratorWrapper {
    private int layer;
    private final StructureHandlerWrapper handler;
    private final IStructureHandler originalHandler;

    public LayerBlueprintIterator(String iteratorId, IStructureHandler handler) {
        this(iteratorId, new StructureHandlerWrapper(handler), handler);
    }

    private LayerBlueprintIterator(String iteratorId, StructureHandlerWrapper handler, IStructureHandler originalHandler) {
        super(StructureIterators.getIterator((String)iteratorId, (IStructureHandler)handler));
        this.handler = handler;
        this.originalHandler = originalHandler;
        handler.setOuter(this);
    }

    public void setLayer(int newLevel) {
        if (this.layer != newLevel) {
            this.layer = newLevel;
            this.handler.setLayerBlueprint();
        }
        this.delegate.setProgressPos(NULL_POS);
    }

    public int getLayer() {
        return this.layer;
    }

    public void setProgressPos(BlockPos localPosition) {
        if (localPosition.equals((Object)NULL_POS)) {
            this.delegate.setProgressPos(NULL_POS);
        } else {
            this.delegate.setProgressPos(localPosition.atY(0));
        }
    }

    public BlockPos getProgressPos() {
        BlockPos progressPos = this.delegate.getProgressPos();
        if (progressPos.equals((Object)NULL_POS)) {
            return NULL_POS;
        }
        return progressPos.atY(this.layer);
    }

    public BlueprintPositionInfo getBluePrintPositionInfo(BlockPos localPos) {
        return this.originalHandler.getBluePrint().getBluePrintPositionInfo(localPos, this.hasEntities());
    }

    public BlockPos getSize() {
        Blueprint blueprint = this.originalHandler.getBluePrint();
        return new BlockPos(blueprint.getSizeX(), (int)blueprint.getSizeY(), blueprint.getSizeZ());
    }

    protected IStructureHandler getStructureHandler() {
        return this.originalHandler;
    }

    private static class StructureHandlerWrapper
    implements IStructureHandler {
        private final IStructureHandler delegate;
        private LayerBlueprintIterator outer;
        private Blueprint layerBlueprint;

        private StructureHandlerWrapper(IStructureHandler delegate) {
            this.delegate = delegate;
        }

        private void setOuter(LayerBlueprintIterator iterator) {
            this.outer = iterator;
        }

        public void setBlueprint(Blueprint blueprint) {
            this.delegate.setBlueprint(blueprint);
            this.layerBlueprint = null;
        }

        public void setMd5(String s) {
            this.delegate.setMd5(s);
        }

        public String getMd5() {
            return this.delegate.getMd5();
        }

        private int getLayer() {
            return this.outer == null ? 0 : this.outer.getLayer();
        }

        private void setLayerBlueprint() {
            Blueprint blueprint = this.delegate.getBluePrint();
            int sizeX = blueprint.getSizeX();
            boolean sizeY = true;
            int sizeZ = blueprint.getSizeZ();
            CompoundTag[][][] tags = blueprint.getTileEntities();
            short[][][] structure = blueprint.getStructure();
            int layer = this.getLayer();
            short[][][] structureAtLayer = new short[][][]{structure[layer]};
            ArrayList<CompoundTag> tagsAtLayer = new ArrayList<CompoundTag>();
            for (int i = 0; i < sizeZ; ++i) {
                for (int j = 0; j < sizeX; ++j) {
                    if (tags[layer][i][j] == null) continue;
                    CompoundTag tag = tags[layer][i][j].copy();
                    tag.putShort("y", (short)0);
                    tagsAtLayer.add(tag);
                }
            }
            this.layerBlueprint = new Blueprint((short)sizeX, 1, (short)sizeZ, blueprint.getPalleteSize(), Arrays.asList(blueprint.getPalette()), (short[][][])structureAtLayer, tagsAtLayer.toArray(new CompoundTag[0]), blueprint.getRequiredMods(), (HolderLookup.Provider)this.getWorld().registryAccess());
        }

        public Blueprint getBluePrint() {
            if (this.layerBlueprint == null) {
                this.setLayerBlueprint();
            }
            return this.layerBlueprint;
        }

        public Level getWorld() {
            return this.delegate.getWorld();
        }

        public BlockPos getWorldPos() {
            return this.delegate.getWorldPos().subtract((Vec3i)this.delegate.getBluePrint().getPrimaryBlockOffset()).offset((Vec3i)this.layerBlueprint.getPrimaryBlockOffset().atY(this.getLayer()));
        }

        public RotationMirror getRotationMirror() {
            return this.delegate.getRotationMirror();
        }

        @Nullable
        public IItemHandler getInventory() {
            return this.delegate.getInventory();
        }

        public void triggerSuccess(BlockPos blockPos, List<ItemStack> list, boolean b) {
            this.delegate.triggerSuccess(blockPos, list, b);
        }

        public void triggerEntitySuccess(BlockPos blockPos, List<ItemStack> list, boolean b) {
            this.delegate.triggerEntitySuccess(blockPos, list, b);
        }

        public boolean isCreative() {
            return this.delegate.isCreative();
        }

        public boolean hasBluePrint() {
            return this.delegate.hasBluePrint();
        }

        public int getStepsPerCall() {
            return this.delegate.getStepsPerCall();
        }

        public int getMaxBlocksCheckedPerCall() {
            return this.delegate.getMaxBlocksCheckedPerCall();
        }

        public boolean isStackFree(@Nullable ItemStack itemStack) {
            return this.delegate.isStackFree(itemStack);
        }

        public boolean allowReplace() {
            return this.delegate.allowReplace();
        }

        public ItemStack getHeldItem() {
            return this.delegate.getHeldItem();
        }

        public boolean replaceWithSolidBlock(BlockState blockState) {
            return this.delegate.replaceWithSolidBlock(blockState);
        }

        public boolean fancyPlacement() {
            return this.delegate.fancyPlacement();
        }

        public boolean shouldBlocksBeConsideredEqual(BlockState blockState, BlockState blockState1) {
            return this.delegate.shouldBlocksBeConsideredEqual(blockState, blockState1);
        }

        public boolean hasRequiredItems(List<ItemStack> list) {
            return this.delegate.hasRequiredItems(list);
        }

        public void prePlacementLogic(BlockPos blockPos, BlockState blockState, List<ItemStack> list) {
            this.delegate.prePlacementLogic(blockPos, blockState, list);
        }

        public BlockState getSolidBlockForPos(BlockPos blockPos, @Nullable Function<BlockPos, BlockState> function) {
            return this.delegate.getSolidBlockForPos(blockPos, function);
        }

        public boolean isReady() {
            return this.delegate.isReady();
        }
    }
}

