/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.ai.combat;

import com.minecolonies.api.entity.ai.combat.CombatAIStates;
import com.minecolonies.api.entity.ai.combat.threat.IThreatTableEntity;
import com.minecolonies.api.entity.ai.combat.threat.ThreatTableEntry;
import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.TickingTransition;
import com.minecolonies.api.entity.other.AbstractFastMinecoloniesEntity;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.core.entity.ai.combat.TargetAI;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class AttackMoveAI<T extends Mob>
extends TargetAI<T> {
    private static final long STOP_PERSECUTION_AFTER = 1200L;
    private PathResult targetPath = null;
    protected long nextAttackTime = 0L;
    private int pathAttempts = 0;

    public AttackMoveAI(T owner, ITickRateStateMachine stateMachine) {
        super(owner, 80, stateMachine);
        stateMachine.addTransition(new TickingTransition<IState>(CombatAIStates.ATTACKING, () -> true, this::tryAttack, 5));
        stateMachine.addTransition(new TickingTransition<IState>(CombatAIStates.ATTACKING, () -> true, this::move, 10));
    }

    private IState move() {
        if (!this.checkForTarget()) {
            return CombatAIStates.NO_TARGET;
        }
        ThreatTableEntry nextTarget = ((IThreatTableEntity)this.user).getThreatTable().getTarget();
        if (nextTarget == null) {
            return CombatAIStates.NO_TARGET;
        }
        boolean canSeeTarget = this.user.getSensing().hasLineOfSight((Entity)this.target);
        if (canSeeTarget) {
            nextTarget.setLastSeen(this.user.level().getGameTime());
        } else if (this.user.level().getGameTime() - nextTarget.getLastSeen() > 1200L) {
            this.resetTarget();
            return null;
        }
        if (!this.isInAttackDistance(this.target) || !canSeeTarget) {
            this.user.lookAt((Entity)this.target, 180.0f, 180.0f);
            this.user.getLookControl().setLookAt((Entity)this.target, 180.0f, 180.0f);
            if (this.pathAttempts > 5 || this.targetPath != null && this.targetPath.isDone() && this.targetPath.failedToReachDestination()) {
                this.pathAttempts = 0;
                this.targetPath = null;
                ((IThreatTableEntity)this.user).getThreatTable().addThreat(this.target, -1);
                if (nextTarget.getThreat() < 5) {
                    this.resetTarget();
                    return null;
                }
            }
            if (this.targetPath == null || this.user.getNavigation().isDone() || this.targetPath.isDone() && this.targetPath.hasPath() && this.targetPath.getPath().getTarget().distSqr((Vec3i)this.target.blockPosition()) > Math.pow(this.getAttackDistance(), 2.0) - 1.0) {
                this.targetPath = this.moveInAttackPosition(this.target);
                ++this.pathAttempts;
            }
        }
        return null;
    }

    @Override
    public void resetTarget() {
        super.resetTarget();
        this.targetPath = null;
        this.pathAttempts = 0;
    }

    protected boolean isInAttackDistance(LivingEntity target) {
        return (double)this.user.distanceTo((Entity)target) <= this.getAttackDistance();
    }

    protected IState tryAttack() {
        if (!this.checkForTarget() || !this.canAttack()) {
            return CombatAIStates.NO_TARGET;
        }
        if (this.nextAttackTime >= this.user.level().getGameTime() || !this.isInDistanceForAttack(this.target)) {
            return null;
        }
        if (this.user.getSensing().hasLineOfSight((Entity)this.target)) {
            this.pathAttempts = 0;
            this.user.getLookControl().setLookAt((Entity)this.target);
            this.doAttack(this.target);
            this.nextAttackTime = this.user.level().getGameTime() + (long)this.getAttackDelay();
        }
        return null;
    }

    public boolean canAttack() {
        return true;
    }

    protected boolean isInDistanceForAttack(LivingEntity target) {
        return this.isInAttackDistance(target);
    }

    protected void doAttack(LivingEntity target) {
        target.hurt(target.level().damageSources().source(DamageSourceKeys.DEFAULT, (Entity)this.user), 5.0f);
        this.user.swing(InteractionHand.MAIN_HAND);
    }

    protected double getAttackDistance() {
        return 5.0;
    }

    protected int getAttackDelay() {
        return 40;
    }

    protected PathResult moveInAttackPosition(LivingEntity target) {
        EntityNavigationUtils.walkToPos((AbstractFastMinecoloniesEntity)this.user, target.blockPosition(), 1, false);
        return ((MinecoloniesAdvancedPathNavigate)this.user.getNavigation()).getPathResult();
    }
}

