/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.generalcommands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.core.colony.events.raid.norsemenevent.NorsemenShipRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.PirateGroundRaidEvent;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;

public class CommandRaidAll
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        return this.raidsExecute(context, "");
    }

    public int onSpecificExecute(CommandContext<CommandSourceStack> context) {
        if (!this.checkPreCondition(context)) {
            return 0;
        }
        return this.raidsExecute(context, StringArgumentType.getString(context, (String)"raidtype"));
    }

    public int raidsExecute(CommandContext<CommandSourceStack> context, String raidType) {
        if (StringArgumentType.getString(context, (String)"raidtime").equals("now")) {
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                colony.getRaiderManager().raiderEvent(raidType, true);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.raidtonight", (Object[])new Object[0]), true);
            return 1;
        }
        if (StringArgumentType.getString(context, (String)"raidtime").equals("tonight")) {
            for (IColony colony : IColonyManager.getInstance().getAllColonies()) {
                colony.getRaiderManager().setRaidNextNight(true, raidType);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.raidtonight", (Object[])new Object[0]), true);
            return 1;
        }
        return 0;
    }

    @Override
    public String getName() {
        return "raid-All";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        ArrayList<String> raidTypes = new ArrayList<String>();
        for (ColonyEventTypeRegistryEntry type : IMinecoloniesAPI.getInstance().getColonyEventRegistry()) {
            if (type.getRegistryName().getPath().equals(PirateGroundRaidEvent.PIRATE_GROUND_RAID_EVENT_TYPE_ID.getPath()) || type.getRegistryName().getPath().equals(NorsemenShipRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.getPath())) continue;
            raidTypes.add(type.getRegistryName().getPath());
        }
        String[] opt = new String[]{"now", "tonight"};
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(((RequiredArgumentBuilder)IMCCommand.newArgument("raidtime", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest((String[])opt, (SuggestionsBuilder)builder)).then(IMCCommand.newArgument("raidtype", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest((Iterable)raidTypes, (SuggestionsBuilder)builder)).executes(this::onSpecificExecute))).executes(this::checkPreConditionAndExecute));
    }
}

