/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.commandTypes;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public interface IMCColonyOfficerCommand
extends IMCCommand {
    @Override
    default public boolean checkPreCondition(CommandContext<CommandSourceStack> context) {
        if (((CommandSourceStack)context.getSource()).hasPermission(4)) {
            return true;
        }
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        if (!(sender instanceof Player)) {
            return false;
        }
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
        if (colony == null) {
            MessageUtils.format("com.minecolonies.command.colonyidnotfound", colonyID).sendTo((Player)sender);
            return false;
        }
        return IMCCommand.isPlayerOped((Player)sender) || colony.getPermissions().getRank((Player)sender).isColonyManager();
    }
}

