/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.colony.events.raid.norsemenevent.NorsemenShipRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.PirateGroundRaidEvent;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandRaid
implements IMCOPCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        return this.raidExecute(context, "");
    }

    public int onSpecificExecute(CommandContext<CommandSourceStack> context) {
        try {
            if (!this.checkPreCondition(context)) {
                return 0;
            }
            return this.raidExecute(context, StringArgumentType.getString(context, (String)"raidtype"));
        }
        catch (Throwable e) {
            Log.getLogger().warn("Error during running command:", e);
            return 0;
        }
    }

    public int raidExecute(CommandContext<CommandSourceStack> context, String raidType) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        boolean allowShips = BoolArgumentType.getBool(context, (String)"allowships");
        if (StringArgumentType.getString(context, (String)"raidtime").equals("now")) {
            IRaiderManager.RaidSpawnResult result = colony.getRaiderManager().raiderEvent(raidType, true, allowShips);
            if (result == IRaiderManager.RaidSpawnResult.SUCCESS) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.raidnow.success", (Object[])new Object[]{colony.getName()}), true);
                return 1;
            }
            ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatableEscape((String)"com.minecolonies.command.raidnow.failure", (Object[])new Object[]{colony.getName(), result}));
        } else if (StringArgumentType.getString(context, (String)"raidtime").equals("tonight")) {
            if (!colony.getRaiderManager().canRaid()) {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.raidnow.failure", (Object[])new Object[]{colony.getName(), IRaiderManager.RaidSpawnResult.CANNOT_RAID}), true);
                return 1;
            }
            colony.getRaiderManager().setRaidNextNight(true, raidType, allowShips);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.raidtonight.success", (Object[])new Object[]{colony.getName()}), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "raid";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        ArrayList<String> raidTypes = new ArrayList<String>();
        for (ColonyEventTypeRegistryEntry type : IMinecoloniesAPI.getInstance().getColonyEventRegistry()) {
            if (type.getRegistryName().getPath().equals(PirateGroundRaidEvent.PIRATE_GROUND_RAID_EVENT_TYPE_ID.getPath()) || type.getRegistryName().getPath().equals(NorsemenShipRaidEvent.NORSEMEN_RAID_EVENT_TYPE_ID.getPath())) continue;
            raidTypes.add(type.getRegistryName().getPath());
        }
        String[] opt = new String[]{"now", "tonight"};
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("raidtime", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest((String[])opt, (SuggestionsBuilder)builder)).then(((RequiredArgumentBuilder)IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("raidtype", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest((Iterable)raidTypes, (SuggestionsBuilder)builder)).then(IMCCommand.newArgument("allowships", BoolArgumentType.bool()).executes(this::onSpecificExecute)))).executes(this::checkPreConditionAndExecute)));
    }
}

