/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class CommandCanRaiderSpawn
implements IMCOPCommand {
    private static final String CANSPAWN_ARG = "canSpawn";

    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)((CommandSourceStack)context.getSource()).getLevel().dimension());
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), true);
            return 0;
        }
        boolean canHaveBarbEvents = BoolArgumentType.getBool(context, (String)CANSPAWN_ARG);
        colony.getRaiderManager().setCanHaveRaiderEvents(canHaveBarbEvents);
        colony.markDirty();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatableEscape((String)"com.minecolonies.command.canspawnraider.success", (Object[])new Object[]{colony.getName(), canHaveBarbEvents}), true);
        return 1;
    }

    @Override
    public String getName() {
        return "canSpawnRaiders";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument(CANSPAWN_ARG, BoolArgumentType.bool()).executes(this::checkPreConditionAndExecute)));
    }
}

