/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.citizencommands;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.pathfinding.IMinecoloniesNavigator;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.commands.commandTypes.IMCColonyOfficerCommand;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CommandCitizenInfo
implements IMCColonyOfficerCommand {
    @Override
    public int onExecute(CommandContext<CommandSourceStack> context) {
        AbstractEntityCitizen entityCitizen;
        Entity sender = ((CommandSourceStack)context.getSource()).getEntity();
        int colonyID = IntegerArgumentType.getInteger(context, (String)"colonyID");
        IColony colony = IColonyManager.getInstance().getColonyByDimension(colonyID, (ResourceKey<Level>)(sender == null ? Level.OVERWORLD : ((CommandSourceStack)context.getSource()).getLevel().dimension()));
        if (colony == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.colonyidnotfound", (Object[])new Object[]{colonyID}), false);
            return 0;
        }
        ICitizenData citizenData = colony.getCitizenManager().getCivilian(IntegerArgumentType.getInteger(context, (String)"citizenID"));
        if (citizenData == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.notfound"), false);
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.desc", (Object[])new Object[]{citizenData.getId(), citizenData.getName()}), false);
        Optional<AbstractEntityCitizen> optionalEntityCitizen = citizenData.getEntity();
        if (optionalEntityCitizen.isPresent()) {
            AbstractEntityCitizen entityCitizen2 = optionalEntityCitizen.get();
            BlockPos citizenPosition = entityCitizen2.blockPosition();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.pos", (Object[])new Object[]{citizenPosition.getX(), citizenPosition.getY(), citizenPosition.getZ()}).withStyle(CommandCitizenInfo.styleWithTeleport(citizenPosition)), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.health", (Object[])new Object[]{Float.valueOf(entityCitizen2.getHealth()), Float.valueOf(entityCitizen2.getMaxHealth())}), false);
        } else {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.pos", (Object[])new Object[]{citizenData.getLastPosition().getX(), citizenData.getLastPosition().getY(), citizenData.getLastPosition().getZ()}).withStyle(CommandCitizenInfo.styleWithTeleport(citizenData.getLastPosition())), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.notloaded"), false);
        }
        BlockPos homePosition = citizenData.getHomePosition();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.homepos", (Object[])new Object[]{homePosition.getX(), homePosition.getY(), homePosition.getZ()}).withStyle(CommandCitizenInfo.styleWithTeleport(homePosition)), false);
        if (citizenData.getWorkBuilding() == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.workposnull"), false);
        } else {
            BlockPos workingPosition = citizenData.getWorkBuilding().getPosition();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.workpos", (Object[])new Object[]{workingPosition.getX(), workingPosition.getY(), workingPosition.getZ()}).withStyle(CommandCitizenInfo.styleWithTeleport(workingPosition)), false);
        }
        if (citizenData.getJob() == null) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.jobnull"), false);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.noactivity"), false);
        } else if (citizenData.getWorkBuilding() != null && citizenData.getWorkBuilding().hasModule(WorkerBuildingModule.class)) {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.job", (Object[])new Object[]{((WorkerBuildingModule)citizenData.getWorkBuilding().getFirstModuleOccurance(WorkerBuildingModule.class)).getJobEntry().getTranslationKey()}), false);
            if (optionalEntityCitizen.isPresent()) {
                entityCitizen = optionalEntityCitizen.get();
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.activity", (Object[])new Object[]{((EntityCitizen)entityCitizen).getCitizenAI().getState().toString(), entityCitizen.getCitizenJobHandler().getColonyJob().getNameTagDescription(), entityCitizen.getCitizenJobHandler().getWorkAI().getState().toString()}), false);
            }
        }
        if (optionalEntityCitizen.isPresent()) {
            entityCitizen = optionalEntityCitizen.get();
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)("Stuck level: " + ((IMinecoloniesNavigator)((Object)entityCitizen.getNavigation())).getStuckHandler().getStuckLevel())), false);
        }
        if (citizenData.getCitizenFoodHandler() != null) {
            Object lastEaten = "";
            for (Item item : citizenData.getCitizenFoodHandler().getLastEatenFoods()) {
                ItemStack stack = new ItemStack((ItemLike)item);
                lastEaten = (String)lastEaten + stack.getHoverName().getString() + ", ";
            }
            String lastEatenCompiled = ((String)lastEaten).substring(0, ((String)lastEaten).length() - 2);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.translatable((String)"com.minecolonies.command.citizeninfo.food", (Object[])new Object[]{citizenData.getCitizenFoodHandler().hasFullFoodHistory(), citizenData.getCitizenFoodHandler().getFoodHappinessStats().quality(), citizenData.getCitizenFoodHandler().getFoodHappinessStats().diversity(), lastEatenCompiled}), false);
        }
        return 1;
    }

    private static Style styleWithTeleport(BlockPos pos) {
        return Style.EMPTY.withClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp " + pos.getX() + " " + pos.getY() + " " + pos.getZ()));
    }

    @Override
    public String getName() {
        return "info";
    }

    @Override
    public LiteralArgumentBuilder<CommandSourceStack> build() {
        return (LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then(IMCCommand.newArgument("colonyID", IntegerArgumentType.integer((int)1)).then(IMCCommand.newArgument("citizenID", IntegerArgumentType.integer((int)1)).executes(this::checkPreConditionAndExecute)));
    }
}

