/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.resolvers;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.requestable.IConcreteDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.INonExhaustiveDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingWareHouse;
import com.minecolonies.core.colony.requestsystem.resolvers.core.AbstractWarehouseRequestResolver;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class WarehouseConcreteRequestResolver
extends AbstractWarehouseRequestResolver {
    public WarehouseConcreteRequestResolver(@NotNull ILocation location, @NotNull IToken<?> token) {
        super(location, token);
    }

    @Override
    protected int getWarehouseInternalCount(BuildingWareHouse wareHouse, IRequest<? extends IDeliverable> requestToCheck) {
        IDeliverable deliverable = requestToCheck.getRequest();
        if (!(deliverable instanceof IConcreteDeliverable)) {
            return 0;
        }
        boolean ignoreNBT = false;
        boolean ignoreDamage = false;
        if (deliverable instanceof Stack) {
            Stack stack = (Stack)deliverable;
            ignoreNBT = !stack.matchNBT();
            ignoreDamage = !stack.matchDamage();
        }
        int totalCount = 0;
        for (ItemStack possible : ((IConcreteDeliverable)deliverable).getRequestedItems()) {
            IDeliverable iDeliverable = requestToCheck.getRequest();
            if (iDeliverable instanceof INonExhaustiveDeliverable) {
                INonExhaustiveDeliverable neDeliverable = (INonExhaustiveDeliverable)iDeliverable;
                totalCount += Math.max(0, InventoryUtils.hasBuildingEnoughElseCount((IBuilding)wareHouse, new ItemStorage(possible, requestToCheck.getRequest().getMinimumCount(), ignoreDamage, ignoreNBT), requestToCheck.getRequest().getCount() + neDeliverable.getLeftOver()) - neDeliverable.getLeftOver());
            } else {
                totalCount += InventoryUtils.hasBuildingEnoughElseCount((IBuilding)wareHouse, new ItemStorage(possible, requestToCheck.getRequest().getMinimumCount(), ignoreDamage, ignoreNBT), requestToCheck.getRequest().getCount());
            }
            if (totalCount < requestToCheck.getRequest().getCount()) continue;
            return totalCount;
        }
        return totalCount;
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

