/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs;

import com.minecolonies.api.client.render.modeltype.ModModelTypes;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.jobs.AbstractJobCrafter;
import com.minecolonies.core.entity.ai.workers.service.EntityAIWorkEnchanter;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.NotNull;

public class JobEnchanter
extends AbstractJobCrafter<EntityAIWorkEnchanter, JobEnchanter> {
    private static final int MAX_WAITING_TICKS = 60;
    private BlockPos posToDrainFrom = null;
    private int waitingTicks = 0;

    public JobEnchanter(ICitizenData entity) {
        super(entity);
    }

    @Override
    @NotNull
    public ResourceLocation getModel() {
        return ModModelTypes.ENCHANTER_ID;
    }

    @Override
    public EntityAIWorkEnchanter generateAI() {
        return new EntityAIWorkEnchanter(this);
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        if (compound.contains("buildingtodrain")) {
            this.posToDrainFrom = BlockPosUtil.read(compound, "buildingtodrain");
        }
        this.waitingTicks = compound.getInt("waitingticks");
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        if (this.posToDrainFrom != null) {
            BlockPosUtil.write(compound, "buildingtodrain", this.posToDrainFrom);
        }
        compound.putInt("waitingticks", this.waitingTicks);
        return compound;
    }

    public void setBuildingToDrainFrom(BlockPos pos) {
        this.posToDrainFrom = pos;
    }

    public BlockPos getPosToDrainFrom() {
        return this.posToDrainFrom;
    }

    public boolean incrementWaitingTicks() {
        if (++this.waitingTicks > 60) {
            this.waitingTicks = 0;
            return false;
        }
        return true;
    }

    @Override
    public void playSound(BlockPos blockPos, EntityCitizen worker) {
        worker.queueSound(SoundEvents.ENCHANTMENT_TABLE_USE, worker.blockPosition().above(), 10, 0, 0.5f, worker.getRandom().nextFloat());
    }
}

