/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.events.raid.pirateEvent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.core.colony.events.raid.AbstractShipRaidEvent;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.NotNull;

public class PirateRaidEvent
extends AbstractShipRaidEvent {
    public static final ResourceLocation PIRATE_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "pirate_raid");
    public static final String SHIP_NAME = "pirate_ship";

    public PirateRaidEvent(@NotNull IColony colony) {
        super(colony);
    }

    @Override
    public String getShipDesc() {
        return SHIP_NAME;
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return PIRATE_RAID_EVENT_TYPE_ID;
    }

    public static IColonyEvent loadFromNBT(@NotNull IColony colony, @NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        PirateRaidEvent raidEvent = new PirateRaidEvent(colony);
        raidEvent.deserializeNBT(provider, compound);
        return raidEvent;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.PIRATE;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.ARCHERPIRATE;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.CHIEFPIRATE;
    }

    @Override
    protected MutableComponent getDisplayName() {
        return Component.translatableEscape((String)"com.minecolonies.coremod.raid.pirate.name", (Object[])new Object[0]);
    }
}

