/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.events.raid.pirateEvent;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.core.colony.events.raid.HordeRaidEvent;
import com.minecolonies.core.entity.mobs.raider.pirates.EntityArcherPirateRaider;
import com.minecolonies.core.entity.mobs.raider.pirates.EntityCaptainPirateRaider;
import com.minecolonies.core.entity.mobs.raider.pirates.EntityPirateRaider;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public class PirateGroundRaidEvent
extends HordeRaidEvent {
    public static final ResourceLocation PIRATE_GROUND_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "pirate_ground_raid");

    public PirateGroundRaidEvent(IColony colony) {
        super(colony);
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return PIRATE_GROUND_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void onStart() {
        super.onStart();
    }

    @Override
    protected void updateRaidBar() {
        super.updateRaidBar();
        this.raidBar.setDarkenScreen(true);
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
    }

    @Override
    public void registerEntity(Entity entity) {
        if (!(entity instanceof AbstractEntityMinecoloniesRaider) || !entity.isAlive()) {
            entity.remove(Entity.RemovalReason.DISCARDED);
            return;
        }
        if (entity instanceof EntityCaptainPirateRaider && this.boss.keySet().size() < this.horde.numberOfBosses) {
            this.boss.put(entity, entity.getUUID());
            return;
        }
        if (entity instanceof EntityArcherPirateRaider && this.archers.keySet().size() < this.horde.numberOfArchers) {
            this.archers.put(entity, entity.getUUID());
            return;
        }
        if (entity instanceof EntityPirateRaider && this.normal.keySet().size() < this.horde.numberOfRaiders) {
            this.normal.put(entity, entity.getUUID());
            return;
        }
        entity.remove(Entity.RemovalReason.DISCARDED);
    }

    @Override
    public void onEntityDeath(LivingEntity entity) {
        super.onEntityDeath(entity);
        if (!(entity instanceof AbstractEntityMinecoloniesRaider)) {
            return;
        }
        if (entity instanceof EntityCaptainPirateRaider) {
            this.boss.remove(entity);
            --this.horde.numberOfBosses;
        }
        if (entity instanceof EntityArcherPirateRaider) {
            this.archers.remove(entity);
            --this.horde.numberOfArchers;
        }
        if (entity instanceof EntityPirateRaider) {
            this.normal.remove(entity);
            --this.horde.numberOfRaiders;
        }
        --this.horde.hordeSize;
        if (this.horde.hordeSize == 0) {
            this.status = EventStatus.DONE;
        }
        this.sendHordeMessage();
    }

    public static PirateGroundRaidEvent loadFromNBT(IColony colony, CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        PirateGroundRaidEvent event = new PirateGroundRaidEvent(colony);
        event.deserializeNBT(provider, compound);
        return event;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.PIRATE;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return ModEntities.ARCHERPIRATE;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.CHIEFPIRATE;
    }

    @Override
    protected MutableComponent getDisplayName() {
        return Component.translatableEscape((String)"com.minecolonies.coremod.raid.pirate.name", (Object[])new Object[0]);
    }
}

