/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.crafting;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.crafting.IImmutableItemStorageFactory;
import com.minecolonies.api.crafting.ImmutableItemStorage;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.constant.TypeConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ImmutableItemStorageFactory
implements IImmutableItemStorageFactory {
    @Override
    @NotNull
    public TypeToken<? extends ImmutableItemStorage> getFactoryOutputType() {
        return TypeConstants.IMMUTABLEITEMSTORAGE;
    }

    @Override
    @NotNull
    public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
        return TypeConstants.FACTORYVOIDINPUT;
    }

    @Override
    public short getSerializationId() {
        return 45;
    }

    @Override
    public CompoundTag serialize(@NotNull HolderLookup.Provider provider, IFactoryController controller, ImmutableItemStorage output) {
        @NotNull CompoundTag compound = StandardFactoryController.getInstance().serializeTag(provider, output.copy());
        return compound;
    }

    @Override
    public ImmutableItemStorage deserialize(@NotNull HolderLookup.Provider provider, IFactoryController controller, CompoundTag nbt) throws Throwable {
        ItemStorage readStorage = (ItemStorage)StandardFactoryController.getInstance().deserializeTag(provider, nbt);
        return readStorage.toImmutable();
    }

    @Override
    public void serialize(IFactoryController controller, ImmutableItemStorage output, RegistryFriendlyByteBuf packetBuffer) {
        StandardFactoryController.getInstance().serialize(packetBuffer, output.copy());
    }

    @Override
    public ImmutableItemStorage deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
        @NotNull ItemStorage newItem = (ItemStorage)StandardFactoryController.getInstance().deserialize(buffer);
        return newItem.toImmutable();
    }

    @Override
    public ImmutableItemStorage getNewInstance(ItemStack stack, int size) {
        @NotNull ItemStorage newItem = new ItemStorage(stack);
        newItem.setAmount(size);
        return newItem.toImmutable();
    }
}

