/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.structurize.api.RotationMirror;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IRSComponent;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.colony.requestsystem.request.RequestState;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.colony.requestsystem.resolver.IRequestResolver;
import com.minecolonies.core.client.gui.WindowPostBox;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class PostBox
extends AbstractBuilding
implements IRSComponent {
    private static final String POST_BOX = "postbox";

    public PostBox(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public ImmutableCollection<IRequestResolver<?>> createResolvers() {
        return ImmutableList.of();
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return POST_BOX;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 0;
    }

    @Override
    public boolean canBeGathered() {
        return false;
    }

    @Override
    public void onRequestedRequestCancelled(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
        super.onRequestedRequestCancelled(manager, request);
        if (request.getState() == RequestState.FAILED && request.getRequest() instanceof Stack) {
            IDeliverable req = ((Stack)request.getRequest()).copyWithCount(((Stack)request.getRequest()).getCount());
            this.createRequest(req, false);
        }
    }

    @Override
    public Tuple<BlockPos, BlockPos> getCorners() {
        return new Tuple((Object)this.getPosition(), (Object)this.getPosition());
    }

    @Override
    public RotationMirror getRotationMirror() {
        return RotationMirror.NONE;
    }

    public static class View
    extends AbstractBuildingView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public BOWindow getWindow() {
            return new WindowPostBox(this);
        }

        @Override
        @NotNull
        public MutableComponent getRequesterDisplayName(@NotNull IRequestManager manager, @NotNull IRequest<?> request) {
            return Component.translatableEscape((String)"block.minecolonies.blockpostbox.name", (Object[])new Object[0]);
        }
    }
}

