/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;

public class BuildingArchery
extends AbstractBuilding {
    private static final String SCHEMATIC_NAME = "archery";
    private final List<BlockPos> shootingStands = new ArrayList<BlockPos>();
    private final List<BlockPos> shootingTargets = new ArrayList<BlockPos>();

    public BuildingArchery(@NotNull IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        if (block == Blocks.TARGET) {
            this.shootingTargets.add(pos);
        } else if (block == Blocks.GLOWSTONE) {
            this.shootingStands.add(pos);
        }
        super.registerBlockPosition(block, pos, world);
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        this.shootingTargets.clear();
        this.shootingStands.clear();
        ListTag targetList = compound.getList("archeryTargets", 10);
        this.shootingTargets.addAll(NBTUtils.streamCompound(targetList).map(targetCompound -> BlockPosUtil.read(targetCompound, "target")).collect(Collectors.toList()));
        ListTag standTagList = compound.getList("archeryStands", 10);
        this.shootingStands.addAll(NBTUtils.streamCompound(standTagList).map(targetCompound -> BlockPosUtil.read(targetCompound, "stand")).collect(Collectors.toList()));
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        ListTag targetList = this.shootingTargets.stream().map(target -> BlockPosUtil.write(new CompoundTag(), "target", target)).collect(NBTUtils.toListNBT());
        compound.put("archeryTargets", (Tag)targetList);
        ListTag standTagList = this.shootingStands.stream().map(target -> BlockPosUtil.write(new CompoundTag(), "stand", target)).collect(NBTUtils.toListNBT());
        compound.put("archeryStands", (Tag)standTagList);
        return compound;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SCHEMATIC_NAME;
    }

    public BlockPos getRandomShootingStandPosition(RandomSource random) {
        List<BlockPos> tagged = this.getLocationsFromTag("work");
        if (!tagged.isEmpty()) {
            return tagged.get(random.nextInt(tagged.size()));
        }
        if (!this.shootingStands.isEmpty()) {
            return this.shootingStands.get(random.nextInt(this.shootingStands.size()));
        }
        return null;
    }

    public BlockPos getRandomShootingTarget(RandomSource random) {
        if (!this.shootingTargets.isEmpty()) {
            return this.shootingTargets.get(random.nextInt(this.shootingTargets.size()));
        }
        return null;
    }
}

