/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildingextensions;

import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildingextensions.modules.IBuildingExtensionModule;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.modules.ModuleContainerUtils;
import com.minecolonies.api.util.BlockPosUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingExtension
implements IBuildingExtension {
    private final List<IBuildingExtensionModule> modules = new ArrayList<IBuildingExtensionModule>();
    private final BuildingExtensionRegistries.BuildingExtensionEntry buildingExtensionEntry;
    private final BlockPos position;
    @Nullable
    private BlockPos buildingId = null;
    private final IBuildingExtension.ExtensionId extensionId;

    protected AbstractBuildingExtension(@NotNull BuildingExtensionRegistries.BuildingExtensionEntry buildingExtensionEntry, @NotNull BlockPos position) {
        this.buildingExtensionEntry = buildingExtensionEntry;
        this.position = position;
        this.extensionId = new IBuildingExtension.ExtensionId(position, buildingExtensionEntry);
    }

    @Override
    public boolean hasModule(Class<? extends IBuildingExtensionModule> clazz) {
        return ModuleContainerUtils.hasModule(this.modules, clazz);
    }

    @Override
    public boolean hasModule(BuildingEntry.ModuleProducer<?, ?> producer) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    @NotNull
    public <T extends IBuildingExtensionModule> T getFirstModuleOccurance(Class<T> clazz) {
        return (T)((IBuildingExtensionModule)ModuleContainerUtils.getFirstModuleOccurance(this.modules, clazz, "The module of class: " + clazz.toString() + "should never be null! Building extension:" + String.valueOf(this.getBuildingExtensionType().getRegistryName()) + " pos:" + String.valueOf(this.getPosition())));
    }

    @Override
    @NotNull
    public <M extends IBuildingModule, V extends IBuildingModuleView> M getModule(BuildingEntry.ModuleProducer<M, V> producer) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    public IBuildingModule getModule(int id) {
        throw new RuntimeException("Not implemented");
    }

    @Override
    @NotNull
    public <T extends IBuildingExtensionModule> List<T> getModulesByType(Class<T> clazz) {
        return ModuleContainerUtils.getModules(this.modules, clazz);
    }

    @Override
    @NotNull
    public <T extends IBuildingExtensionModule> T getModuleMatching(Class<T> clazz, Predicate<? super T> modulePredicate) {
        return (T)((IBuildingExtensionModule)ModuleContainerUtils.getModuleMatching(this.modules, clazz, modulePredicate, "no matching module for building extension:" + String.valueOf(this.getBuildingExtensionType().getRegistryName()) + " pos:" + this.getPosition().toShortString()));
    }

    @Override
    public void registerModule(@NotNull IBuildingExtensionModule module) {
        this.modules.add(module);
    }

    @Override
    @NotNull
    public final BuildingExtensionRegistries.BuildingExtensionEntry getBuildingExtensionType() {
        return this.buildingExtensionEntry;
    }

    @Override
    @NotNull
    public final BlockPos getPosition() {
        return this.position;
    }

    @Override
    @Nullable
    public final BlockPos getBuildingId() {
        return this.buildingId;
    }

    @Override
    public final void setBuilding(BlockPos buildingId) {
        this.buildingId = buildingId;
    }

    @Override
    public final void resetOwningBuilding() {
        this.buildingId = null;
    }

    @Override
    public final boolean isTaken() {
        return this.buildingId != null;
    }

    @Override
    public final int getSqDistance(IBuildingView building) {
        return (int)Math.sqrt(BlockPosUtil.getDistanceSquared(this.position, building.getPosition()));
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        if (this.buildingId != null) {
            BlockPosUtil.write(compound, "owner", this.buildingId);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        if (compound.contains("owner")) {
            this.buildingId = BlockPosUtil.read(compound, "owner");
        }
    }

    @Override
    public void serialize(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.buildingId != null);
        if (this.buildingId != null) {
            buf.writeBlockPos(this.buildingId);
        }
    }

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.buildingId = buf.readBlockPos();
        }
    }

    @Override
    public int hashCode() {
        int result = this.position.hashCode();
        result = 31 * result + this.buildingExtensionEntry.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBuildingExtension that = (AbstractBuildingExtension)o;
        if (!this.position.equals((Object)that.position)) {
            return false;
        }
        return this.buildingExtensionEntry.equals(that.buildingExtensionEntry);
    }

    @Override
    public IBuildingExtension.ExtensionId getId() {
        return this.extensionId;
    }
}

