/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.google.common.collect.Maps;
import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.blocks.AbstractBlockHut;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.claim.ChunkClaimData;
import com.minecolonies.api.colony.claim.IChunkClaimData;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.savedata.IServerColonySaveData;
import com.minecolonies.api.compatibility.CompatibilityManager;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.eventbus.events.ColonyManagerLoadedModEvent;
import com.minecolonies.api.eventbus.events.ColonyManagerUnloadedModEvent;
import com.minecolonies.api.eventbus.events.colony.ColonyDeletedModEvent;
import com.minecolonies.api.eventbus.events.colony.ColonyViewUpdatedModEvent;
import com.minecolonies.api.sounds.SoundManager;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.client.gui.WindowReactivateBuilding;
import com.minecolonies.core.colony.Colony;
import com.minecolonies.core.colony.ColonyList;
import com.minecolonies.core.colony.ColonyView;
import com.minecolonies.core.colony.requestsystem.management.manager.StandardRecipeManager;
import com.minecolonies.core.network.messages.client.colony.ColonyViewRemoveMessage;
import com.minecolonies.core.util.BackUpHelper;
import com.minecolonies.core.util.ChunkDataHelper;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.LevelTickEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ColonyManager
implements IColonyManager {
    @NotNull
    private final Map<ResourceKey<Level>, ColonyList<IColonyView>> colonyViews = new HashMap<ResourceKey<Level>, ColonyList<IColonyView>>();
    private final IRecipeManager recipeManager = new StandardRecipeManager();
    private final ICompatibilityManager compatibilityManager = new CompatibilityManager();
    private final ICompatibilityManager compatibilityManagerClient = new CompatibilityManager();
    private boolean schematicDownloaded = false;
    private Map<ResourceKey<Level>, Long2ObjectMap<ChunkClaimData>> chunkClaimData = new HashMap<ResourceKey<Level>, Long2ObjectMap<ChunkClaimData>>();
    private SoundManager clientSoundManager;

    @Nullable
    private IServerColonySaveData getColonySaveData(ServerLevel w) {
        return IServerColonySaveData.getOrComputeSaveData(w);
    }

    @Override
    public IColony createColony(@NotNull ServerLevel w, BlockPos pos, @NotNull Player player, @NotNull String colonyName, @NotNull String pack) {
        IServerColonySaveData cap = IServerColonySaveData.getOrComputeSaveData(w);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        IColony colony = cap.createColony(w, colonyName, pos);
        colony.setStructurePack(pack);
        colony.setName(colonyName);
        colony.getPermissions().setOwner(player);
        colony.getPackageManager().addImportantColonyPlayer((ServerPlayer)player);
        colony.getPackageManager().addCloseSubscriber((ServerPlayer)player);
        Log.getLogger().info(String.format("New Colony Id: %d by %s", colony.getID(), player.getName().getString()));
        if (colony.getWorld() == null) {
            Log.getLogger().error("Unable to claim chunks because of the missing world in the colony, please report this to the mod authors!", (Throwable)new Exception());
            return null;
        }
        ChunkDataHelper.claimColonyChunks(w, true, (Colony)colony, colony.getCenter());
        return colony;
    }

    @Override
    public void deleteColonyByWorld(int id, boolean canDestroy, ServerLevel world) {
        this.deleteColony(this.getColonyByWorld(id, (Level)world), canDestroy);
    }

    @Override
    public void deleteColonyByDimension(int id, boolean canDestroy, ResourceKey<Level> dimension) {
        this.deleteColony(this.getColonyByDimension(id, dimension), canDestroy);
    }

    private void deleteColony(@Nullable IColony iColony, boolean canDestroy) {
        if (!(iColony instanceof Colony)) {
            return;
        }
        Colony colony = (Colony)iColony;
        int id = colony.getID();
        ServerLevel world = colony.getWorld();
        if (world == null) {
            Log.getLogger().warn("Deleting Colony " + id + " errored: World is Null");
            return;
        }
        try {
            ChunkDataHelper.claimColonyChunks(world, false, colony, colony.getCenter());
            Log.getLogger().info("Removing citizens for " + id);
            for (ICitizenData citizenData : new ArrayList<ICitizenData>(colony.getCitizenManager().getCitizens())) {
                Log.getLogger().info("Kill Citizen " + citizenData.getName());
                citizenData.getEntity().ifPresent(entityCitizen -> entityCitizen.die(world.damageSources().source(DamageSourceKeys.CONSOLE)));
            }
            Log.getLogger().info("Removing buildings for " + id);
            for (IBuilding building : new ArrayList<IBuilding>(colony.getBuildingManager().getBuildings().values())) {
                try {
                    BlockPos location = building.getPosition();
                    Log.getLogger().info("Delete Building at " + String.valueOf(location));
                    if (canDestroy) {
                        building.deconstruct();
                    }
                    building.destroy();
                    if (!(world.getBlockState(location).getBlock() instanceof AbstractBlockHut)) continue;
                    Log.getLogger().info("Found Block, deleting " + String.valueOf(world.getBlockState(location).getBlock()));
                    world.removeBlock(location, false);
                }
                catch (Exception ex) {
                    Log.getLogger().warn("Something went wrong deleting a building while deleting the colony!", (Throwable)ex);
                }
            }
            try {
                NeoForge.EVENT_BUS.unregister((Object)colony.getEventHandler());
            }
            catch (NullPointerException e) {
                Log.getLogger().warn("Can't unregister the event handler twice");
            }
            Log.getLogger().info("Deleting colony: " + colony.getID());
            IServerColonySaveData cap = this.getColonySaveData(world);
            if (cap == null) {
                Log.getLogger().warn("Missing world capability with colony manager!");
                return;
            }
            IMinecoloniesAPI.getInstance().getEventBus().post(new ColonyDeletedModEvent(colony));
            cap.deleteColony(id);
            BackUpHelper.markColonyDeleted(colony.getID(), colony.getDimension());
            colony.getImportantMessageEntityPlayers().forEach(player -> new ColonyViewRemoveMessage(colony.getID(), colony.getDimension()).sendToPlayer((ServerPlayer)player));
            Log.getLogger().info("Successfully deleted colony: " + id);
        }
        catch (RuntimeException e) {
            Log.getLogger().warn("Deleting Colony " + id + " errored:", (Throwable)e);
        }
    }

    @Override
    public void removeColonyView(int id, ResourceKey<Level> dimension) {
        if (this.colonyViews.containsKey(dimension)) {
            this.colonyViews.get(dimension).remove(id);
        }
    }

    @Override
    @Nullable
    public IColony getColonyByWorld(int id, Level world) {
        if (!(world instanceof ServerLevel)) {
            return null;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        IServerColonySaveData cap = this.getColonySaveData(serverLevel);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        return cap.getColony(id);
    }

    @Override
    @Nullable
    public IColony getColonyByDimension(int id, ResourceKey<Level> registryKey) {
        ServerLevel world = ServerLifecycleHooks.getCurrentServer().getLevel(registryKey);
        if (world == null) {
            return null;
        }
        IServerColonySaveData cap = this.getColonySaveData(world);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return null;
        }
        return cap.getColony(id);
    }

    @Override
    public IBuilding getBuilding(@NotNull Level w, @NotNull BlockPos pos) {
        IBuilding building;
        @Nullable IColony colony = this.getColonyByPosFromWorld(w, pos);
        if (colony != null && (building = colony.getBuildingManager().getBuilding(pos)) != null) {
            return building;
        }
        for (IColony otherColony : this.getColonies(w)) {
            IBuilding building2 = otherColony.getBuildingManager().getBuilding(pos);
            if (building2 == null) continue;
            return building2;
        }
        return null;
    }

    @Override
    public IColony getColonyByPosFromWorld(@Nullable Level w, @NotNull BlockPos pos) {
        if (w == null) {
            return null;
        }
        LevelChunk centralChunk = w.getChunkAt(pos);
        int id = ColonyUtils.getOwningColony((ChunkAccess)centralChunk);
        if (id == 0) {
            return null;
        }
        return this.getColonyByWorld(id, w);
    }

    @Override
    public IColony getColonyByPosFromDim(ResourceKey<Level> registryKey, @NotNull BlockPos pos) {
        return this.getColonyByPosFromWorld((Level)ServerLifecycleHooks.getCurrentServer().getLevel(registryKey), pos);
    }

    @Override
    public boolean isFarEnoughFromColonies(@NotNull Level w, @NotNull BlockPos pos) {
        int blockRange = Math.max((Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).minColonyDistance.get(), (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).initialColonySize.get()) << 4;
        IColony closest = this.getClosestColony(w, pos);
        if (closest != null && BlockPosUtil.getDistance(pos, closest.getCenter()) < (double)blockRange) {
            return false;
        }
        if (w.isClientSide()) {
            return true;
        }
        return ChunkDataHelper.canClaimChunksInRange((Level)((ServerLevel)w), pos, (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).initialColonySize.get());
    }

    @Override
    @NotNull
    public List<IColony> getColonies(@NotNull Level w) {
        if (!(w instanceof ServerLevel)) {
            return Collections.emptyList();
        }
        ServerLevel serverLevel = (ServerLevel)w;
        IServerColonySaveData cap = this.getColonySaveData(serverLevel);
        if (cap == null) {
            Log.getLogger().warn("Missing world capability with colony manager!");
            return Collections.emptyList();
        }
        return cap.getColonies();
    }

    @Override
    @NotNull
    public List<IColony> getAllColonies() {
        ArrayList<IColony> allColonies = new ArrayList<IColony>();
        for (ServerLevel world : ServerLifecycleHooks.getCurrentServer().getAllLevels()) {
            IServerColonySaveData cap = this.getColonySaveData(world);
            if (cap == null) continue;
            allColonies.addAll(cap.getColonies());
        }
        return allColonies;
    }

    @Override
    @NotNull
    public List<IColony> getColoniesAbandonedSince(int abandonedSince) {
        ArrayList<IColony> sortedList = new ArrayList<IColony>();
        for (IColony colony : this.getAllColonies()) {
            if (colony.getLastContactInHours() < abandonedSince) continue;
            sortedList.add(colony);
        }
        return sortedList;
    }

    @Override
    public IBuildingView getBuildingView(ResourceKey<Level> dimension, BlockPos pos) {
        if (this.colonyViews.containsKey(dimension)) {
            for (IColonyView colony : this.colonyViews.get(dimension)) {
                IBuildingView building = colony.getBuilding(pos);
                if (building == null) continue;
                return building;
            }
        }
        return null;
    }

    @Override
    @Nullable
    public IColony getIColony(@NotNull Level w, @NotNull BlockPos pos) {
        return w.isClientSide ? this.getColonyView(w, pos) : this.getColonyByPosFromWorld(w, pos);
    }

    @Override
    public void openReactivationWindow(BlockPos pos) {
        new WindowReactivateBuilding(pos).open();
    }

    @Override
    public IColonyView getColonyView(@NotNull Level w, @NotNull BlockPos pos) {
        LevelChunk centralChunk = w.getChunkAt(pos);
        int id = ColonyUtils.getOwningColony((ChunkAccess)centralChunk);
        if (id == 0) {
            return null;
        }
        return this.getColonyView(id, (ResourceKey<Level>)w.dimension());
    }

    @Override
    @Nullable
    public IColony getClosestIColony(@NotNull Level w, @NotNull BlockPos pos) {
        return w.isClientSide ? this.getClosestColonyView(w, pos) : this.getClosestColony(w, pos);
    }

    @Override
    @Nullable
    public IColonyView getClosestColonyView(@Nullable Level w, @Nullable BlockPos pos) {
        if (w == null || pos == null) {
            return null;
        }
        LevelChunk chunk = w.getChunkAt(pos);
        int owningColony = ColonyUtils.getOwningColony((ChunkAccess)chunk);
        if (owningColony != 0) {
            return this.getColonyView(owningColony, (ResourceKey<Level>)w.dimension());
        }
        IColonyView closestColony = null;
        long closestDist = Long.MAX_VALUE;
        if (this.colonyViews.containsKey(w.dimension())) {
            for (IColonyView c : this.colonyViews.get(w.dimension())) {
                long dist;
                if (c.getDimension() != w.dimension() || c.getCenter() == null || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
                closestColony = c;
                closestDist = dist;
            }
        }
        return closestColony;
    }

    @Override
    public IColony getClosestColony(@NotNull Level w, @NotNull BlockPos pos) {
        LevelChunk chunk = w.getChunkAt(pos);
        int owningColony = ColonyUtils.getOwningColony((ChunkAccess)chunk);
        if (owningColony != 0) {
            return this.getColonyByWorld(owningColony, w);
        }
        IColony closestColony = null;
        long closestDist = Long.MAX_VALUE;
        for (IColony c : this.getColonies(w)) {
            long dist;
            if (c.getDimension() != w.dimension() || (dist = c.getDistanceSquared(pos)) >= closestDist) continue;
            closestColony = c;
            closestDist = dist;
        }
        return closestColony;
    }

    @Override
    @Nullable
    public IColony getIColonyByOwner(@NotNull Level w, @NotNull Player owner) {
        return this.getIColonyByOwner(w, w.isClientSide ? owner.getUUID() : owner.getGameProfile().getId());
    }

    @Override
    @Nullable
    public IColony getIColonyByOwner(@NotNull Level w, UUID owner) {
        return w.isClientSide ? this.getColonyViewByOwner(owner, (ResourceKey<Level>)w.dimension()) : this.getColonyByOwner(owner);
    }

    private IColony getColonyViewByOwner(UUID owner, ResourceKey<Level> dimension) {
        if (this.colonyViews.containsKey(dimension)) {
            for (IColonyView c : this.colonyViews.get(dimension)) {
                ColonyPlayer p = c.getPlayers().get(owner);
                if (p == null || !p.getRank().equals(c.getPermissions().getRankOwner())) continue;
                return c;
            }
        }
        return null;
    }

    @Nullable
    private IColony getColonyByOwner(@Nullable UUID owner) {
        if (owner == null) {
            return null;
        }
        for (IColony colony : this.getAllColonies()) {
            if (!colony.getPermissions().getOwner().equals(owner)) continue;
            return colony;
        }
        return null;
    }

    @Override
    public int getMinimumDistanceBetweenTownHalls() {
        return (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).minColonyDistance.get() * 16;
    }

    @Override
    public void onServerTick(@NotNull ServerTickEvent.Pre event) {
        for (IColony c : this.getAllColonies()) {
            c.onServerTick(event);
        }
    }

    @Override
    public void write(HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        CompoundTag compCompound = new CompoundTag();
        this.compatibilityManager.write(provider, compCompound);
        compound.put("compatabilityManager", (Tag)compCompound);
        compound.putBoolean("dist", true);
        CompoundTag recipeCompound = new CompoundTag();
        this.recipeManager.write(provider, recipeCompound);
        compound.put("recipeManager", (Tag)recipeCompound);
    }

    @Override
    public void read(HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        if (compound.contains("compatabilityManager")) {
            this.compatibilityManager.read(provider, compound.getCompound("compatabilityManager"));
        }
        this.recipeManager.read(provider, compound.getCompound("recipeManager"));
    }

    @Override
    public void onClientTick(@NotNull ClientTickEvent.Pre event) {
        if (Minecraft.getInstance().level == null && !this.colonyViews.isEmpty()) {
            this.colonyViews.clear();
        }
        if (this.clientSoundManager == null) {
            this.clientSoundManager = new SoundManager();
        }
        ColonyManager colonyManager = this;
        colonyManager.clientSoundManager.tick();
    }

    @Override
    public void onWorldTick(@NotNull LevelTickEvent.Pre event) {
        if (!event.getLevel().isClientSide) {
            for (IColony colony : this.getColonies(event.getLevel())) {
                try {
                    colony.onWorldTick(event);
                }
                catch (Exception ex) {
                    Log.getLogger().error("Something went wrong ticking colony: " + colony.getID(), (Throwable)ex);
                }
            }
        }
    }

    @Override
    public void onWorldLoad(@NotNull Level w) {
        if (w instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)w;
            for (IColony c : this.getColonies((Level)world)) {
                c.onWorldLoad(world);
            }
            IMinecoloniesAPI.getInstance().getEventBus().post(new ColonyManagerLoadedModEvent(this));
        }
    }

    @Override
    public void onWorldUnload(@NotNull Level world) {
        if (!world.isClientSide) {
            boolean hasColonies = false;
            for (IColony c : this.getColonies(world)) {
                hasColonies = true;
                c.onWorldUnload(world);
            }
            if (hasColonies) {
                BackUpHelper.backupColonyData((HolderLookup.Provider)world.registryAccess());
            }
            IMinecoloniesAPI.getInstance().getEventBus().post(new ColonyManagerUnloadedModEvent(this));
        }
    }

    @Override
    public void handleColonyViewMessage(int colonyId, @NotNull RegistryFriendlyByteBuf colonyData, boolean isNewSubscription, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            view = ColonyView.createFromNetwork(colonyId, dim);
            if (this.colonyViews.containsKey(dim)) {
                this.colonyViews.get(dim).add(view);
            } else {
                ColonyList<IColonyView> list = new ColonyList<IColonyView>();
                list.add(view);
                this.colonyViews.put(dim, list);
            }
        }
        view.handleColonyViewMessage(colonyData, isNewSubscription);
        IMinecoloniesAPI.getInstance().getEventBus().post(new ColonyViewUpdatedModEvent(view));
    }

    @Override
    public IColonyView getColonyView(int id, ResourceKey<Level> dimension) {
        if (this.colonyViews.containsKey(dimension)) {
            return this.colonyViews.get(dimension).get(id);
        }
        return null;
    }

    @Override
    public void handlePermissionsViewMessage(int colonyID, @NotNull RegistryFriendlyByteBuf data, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyID, dim);
        if (view == null) {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyID), (Throwable)new Exception());
        } else {
            view.handlePermissionsViewMessage(data);
        }
    }

    @Override
    public void handleColonyViewCitizensMessage(int colonyId, int citizenId, RegistryFriendlyByteBuf buf, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            return;
        }
        view.handleColonyViewCitizensMessage(citizenId, buf);
    }

    @Override
    public void handleColonyViewWorkOrderMessage(int colonyId, RegistryFriendlyByteBuf buf, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view == null) {
            return;
        }
        view.handleColonyViewWorkOrderMessage(buf);
    }

    @Override
    public void handleColonyViewRemoveCitizenMessage(int colonyId, int citizenId, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveCitizenMessage(citizenId);
        }
    }

    @Override
    public void handleColonyBuildingViewMessage(int colonyId, BlockPos buildingId, @NotNull RegistryFriendlyByteBuf buf, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyBuildingViewMessage(buildingId, buf);
        } else {
            Log.getLogger().error(String.format("Colony view does not exist for ID #%d", colonyId), (Throwable)new Exception());
        }
    }

    @Override
    public void handleColonyViewRemoveBuildingMessage(int colonyId, BlockPos buildingId, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveBuildingMessage(buildingId);
        }
    }

    @Override
    public void handleColonyViewRemoveWorkOrderMessage(int colonyId, int workOrderId, ResourceKey<Level> dim) {
        IColonyView view = this.getColonyView(colonyId, dim);
        if (view != null) {
            view.handleColonyViewRemoveWorkOrderMessage(workOrderId);
        }
    }

    @Override
    public boolean isSchematicDownloaded() {
        return this.schematicDownloaded;
    }

    @Override
    public void setSchematicDownloaded(boolean downloaded) {
        this.schematicDownloaded = downloaded;
    }

    @Override
    public boolean isCoordinateInAnyColony(@NotNull Level world, BlockPos pos) {
        LevelChunk centralChunk = world.getChunkAt(pos);
        return ColonyUtils.getOwningColony((ChunkAccess)centralChunk) != 0;
    }

    @Override
    public ICompatibilityManager getCompatibilityManager() {
        if (Thread.currentThread().getName().toLowerCase().contains("server")) {
            return this.compatibilityManager;
        }
        return this.compatibilityManagerClient;
    }

    @Override
    public IRecipeManager getRecipeManager() {
        return this.recipeManager;
    }

    @Override
    public int getTopColonyId() {
        int top = 0;
        for (ServerLevel world : ServerLifecycleHooks.getCurrentServer().getAllLevels()) {
            IServerColonySaveData cap = this.getColonySaveData(world);
            int tempTop = cap == null ? 0 : cap.getTopID();
            if (tempTop <= top) continue;
            top = tempTop;
        }
        return top;
    }

    @Override
    public void resetColonyViews() {
        this.colonyViews.clear();
    }

    @Override
    public void addColonyDirect(IColony colony, ServerLevel world) {
        IServerColonySaveData cap = this.getColonySaveData(world);
        if (cap != null) {
            cap.addColony(colony);
        }
    }

    @Override
    public void addClaimData(IColony colony, Long2ObjectMap<ChunkClaimData> claimData) {
        this.chunkClaimData.computeIfAbsent(colony.getDimension(), k -> new Long2ObjectOpenHashMap()).putAll(claimData);
    }

    @Override
    public Map<ChunkPos, IChunkClaimData> getClaimData(ResourceKey<Level> dimension) {
        Map map = (Map)this.chunkClaimData.computeIfAbsent(dimension, k -> new Long2ObjectOpenHashMap());
        return Maps.asMap(map.keySet().stream().map(ChunkPos::new).collect(Collectors.toSet()), p -> map.getOrDefault(p.toLong(), null));
    }

    @Override
    @Nullable
    public IChunkClaimData getClaimData(ResourceKey<Level> dimension, ChunkPos pos) {
        return (IChunkClaimData)this.chunkClaimData.computeIfAbsent(dimension, k -> new Long2ObjectOpenHashMap()).getOrDefault(pos.toLong(), null);
    }

    @Override
    public void addNewChunk(Colony colony, ChunkPos pos, ChunkClaimData chunkClaimData) {
        this.chunkClaimData.computeIfAbsent(colony.getDimension(), k -> new Long2ObjectOpenHashMap()).put(pos.toLong(), (Object)chunkClaimData);
    }
}

