/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.util.Log;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.IItemDecorator;

public class ColonyMapDecorator
implements IItemDecorator {
    private static IColonyView colonyView;
    private static boolean render;
    private long lastChange;

    public boolean render(GuiGraphics graphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        long gametime = Minecraft.getInstance().level.getGameTime();
        if (this.lastChange != gametime && gametime % 40L == 0L) {
            this.lastChange = gametime;
            boolean bl = render = !render;
        }
        if (render && (colonyView = ColonyId.readColonyViewFromItemStack(stack)) != null) {
            try {
                int count = 0;
                for (ICitizenDataView view : colonyView.getCitizens().values()) {
                    if (!view.hasBlockingInteractions()) continue;
                    ++count;
                }
                if (count > 0) {
                    PoseStack ps = graphics.pose();
                    ps.pushPose();
                    ps.translate(0.0f, 0.0f, 500.0f);
                    graphics.drawCenteredString(font, (Component)Component.literal((String)("" + count)), xOffset + 15, yOffset - 2, -47872);
                    ps.popPose();
                    return true;
                }
            }
            catch (Exception e) {
                Log.getLogger().error("Something went wrong with the colonymap item decorator", (Throwable)e);
            }
        }
        return false;
    }

    static {
        render = false;
    }
}

