/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.render;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.resolver.player.IPlayerRequestResolver;
import com.minecolonies.api.colony.requestsystem.resolver.retrying.IRetryingRequestResolver;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.items.component.ColonyId;
import com.minecolonies.api.util.Log;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collection;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.IItemDecorator;

public class ClipBoardDecorator
implements IItemDecorator {
    private static IColonyView colonyView;
    private static boolean render;
    private long lastChange;

    public boolean render(GuiGraphics graphics, Font font, ItemStack stack, int xOffset, int yOffset) {
        long gametime = Minecraft.getInstance().level.getGameTime();
        if (this.lastChange != gametime && gametime % 40L == 0L) {
            this.lastChange = gametime;
            boolean bl = render = !render;
        }
        if (render && (colonyView = ColonyId.readColonyViewFromItemStack(stack)) != null) {
            try {
                HashSet asyncRequest = new HashSet();
                for (ICitizenDataView view : colonyView.getCitizens().values()) {
                    if (view.getJobView() == null) continue;
                    asyncRequest.addAll(view.getJobView().getAsyncRequests());
                }
                IRequestManager requestManager = colonyView.getRequestManager();
                if (requestManager != null) {
                    IPlayerRequestResolver resolver = requestManager.getPlayerResolver();
                    IRetryingRequestResolver retryingRequestResolver = requestManager.getRetryingRequestResolver();
                    HashSet requestTokens = new HashSet();
                    requestTokens.addAll((Collection<IToken<?>>)resolver.getAllAssignedRequests());
                    requestTokens.addAll((Collection<IToken<?>>)retryingRequestResolver.getAllAssignedRequests());
                    int count = 0;
                    for (IToken iToken : requestTokens) {
                        if (asyncRequest.contains(iToken)) continue;
                        ++count;
                    }
                    if (count > 0) {
                        PoseStack ps = graphics.pose();
                        ps.pushPose();
                        ps.translate(0.0f, 0.0f, 500.0f);
                        graphics.drawCenteredString(font, (Component)Component.literal((String)("" + count)), xOffset + 15, yOffset - 2, -47872);
                        ps.popPose();
                        return true;
                    }
                }
            }
            catch (Exception e) {
                Log.getLogger().error("Something went wrong with the clipboard item decorator", (Throwable)e);
            }
        }
        return false;
    }

    static {
        render = false;
    }
}

