/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.CompactColonyReference;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import com.minecolonies.core.commands.ClickEventWithExecutable;
import com.minecolonies.core.network.messages.server.colony.TeleportToColonyMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class WindowAlliancePage
extends AbstractWindowTownHall {
    private final ScrollingList feudsList;
    private final ScrollingList alliesList = (ScrollingList)this.findPaneOfTypeByID("allies", ScrollingList.class);

    public WindowAlliancePage(BuildingTownHall.View building) {
        super(building, "layoutalliance.xml");
        this.feudsList = (ScrollingList)this.findPaneOfTypeByID("feuds", ScrollingList.class);
        this.registerButton("tp", this::teleportToColony);
        this.fillAlliesAndFeudsList();
    }

    private void teleportToColony(@NotNull Button button) {
        int row = this.alliesList.getListElementIndexByPane((Pane)button);
        CompactColonyReference ally = ((ITownHallView)this.building).getColony().getAllies().get(row);
        MessageUtils.format("com.minecolonies.coremod.gui.townhall.tp", ally.name).withPriority(MessageUtils.MessagePriority.IMPORTANT).withClickEvent(new ClickEventWithExecutable(() -> new TeleportToColonyMessage(ally.dimension, ally.id).sendToServer())).sendTo(new Player[]{Minecraft.getInstance().player});
        this.close();
    }

    private void fillAlliesAndFeudsList() {
        this.alliesList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowAlliancePage.this.building).getColony().getAllies().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                CompactColonyReference colonyReference = ((ITownHallView)WindowAlliancePage.this.building).getColony().getAllies().get(index);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.literal((String)colonyReference.name));
                long distance = BlockPosUtil.getDistance2D(colonyReference.center, ((ITownHallView)WindowAlliancePage.this.building).getPosition());
                ((Text)rowPane.findPaneOfTypeByID("dist", Text.class)).setText(Component.literal((String)((int)distance + "b")));
                Button button = (Button)rowPane.findPaneOfTypeByID("tp", Button.class);
                if (colonyReference.hasTownHall && (((ITownHallView)WindowAlliancePage.this.building).getBuildingLevel() < (Integer)((ServerConfiguration)MineColonies.getConfig().getServer()).minThLevelToTeleport.get() || !((ITownHallView)WindowAlliancePage.this.building).canPlayerUseTP())) {
                    button.setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.townhall.toolow", (Object[])new Object[0]));
                    button.disable();
                } else {
                    button.enable();
                }
            }
        });
        this.feudsList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return ((ITownHallView)WindowAlliancePage.this.building).getColony().getFeuds().size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                CompactColonyReference colonyReference = ((ITownHallView)WindowAlliancePage.this.building).getColony().getFeuds().get(index);
                ((Text)rowPane.findPaneOfTypeByID("name", Text.class)).setText(Component.literal((String)colonyReference.name));
                long distance = BlockPosUtil.getDistance2D(colonyReference.center, ((ITownHallView)WindowAlliancePage.this.building).getPosition());
                ((Text)rowPane.findPaneOfTypeByID("dist", Text.class)).setText(Component.literal((String)String.valueOf((int)distance)));
            }
        });
    }

    @Override
    protected String getWindowId() {
        return "alliances";
    }
}

