/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.modules.IAssignmentModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.client.gui.WindowHireWorker;
import com.minecolonies.core.network.messages.server.colony.building.worker.RecallCitizenMessage;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class SpecialAssignmentModuleWindow
extends AbstractModuleWindow {
    private static final String BUTTON_HIRE = "hire";
    private static final String LIST_WORKERS = "workers";
    private static final String LABEL_WORKERNAME = "workerName";

    public SpecialAssignmentModuleWindow(IBuildingView building, String resource) {
        super(building, resource);
        super.registerButton(BUTTON_HIRE, this::hireClicked);
        super.registerButton("recall", this::recallClicked);
    }

    private void recallClicked() {
        new RecallCitizenMessage(this.buildingView).sendToServer();
    }

    protected void hireClicked(@NotNull Button button) {
        if (this.buildingView.getBuildingLevel() == 0) {
            MessageUtils.format("com.minecolonies.coremod.gui.workerhuts.level0", new Object[0]).sendTo(new Player[]{Minecraft.getInstance().player});
            return;
        }
        new WindowHireWorker(this.buildingView.getColony(), this.buildingView.getPosition()).open();
    }

    public void onOpened() {
        super.onOpened();
        final ArrayList<Tuple<String, Integer>> workers = new ArrayList<Tuple<String, Integer>>();
        for (IAssignmentModuleView module : this.buildingView.getModuleViews(IAssignmentModuleView.class)) {
            for (int worker : module.getAssignedCitizens()) {
                workers.add(new Tuple<String, Integer>(Component.translatableEscape((String)module.getJobEntry().getTranslationKey(), (Object[])new Object[0]).getString(), worker));
            }
        }
        if (this.findPaneByID(LIST_WORKERS) != null) {
            ScrollingList workerList = (ScrollingList)this.findPaneOfTypeByID(LIST_WORKERS, ScrollingList.class);
            workerList.setDataProvider(new ScrollingList.DataProvider(){

                public int getElementCount() {
                    return workers.size();
                }

                public void updateElement(int index, @NotNull Pane rowPane) {
                    ICitizenDataView worker = SpecialAssignmentModuleWindow.this.buildingView.getColony().getCitizen((Integer)((Tuple)workers.get(index)).getB());
                    if (worker != null) {
                        ((Text)rowPane.findPaneOfTypeByID(SpecialAssignmentModuleWindow.LABEL_WORKERNAME, Text.class)).setText(Component.literal((String)(Component.translatableEscape((String)((String)((Tuple)workers.get(index)).getA()), (Object[])new Object[0]).getString() + ": " + worker.getName())));
                    }
                }
            });
        }
    }
}

