/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.client.gui.ColorPalette;
import com.minecolonies.core.client.gui.townhall.AbstractWindowTownHall;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.BannerPatterns;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class WindowBannerPicker
extends Screen {
    private static final int GUI_Y = 30;
    private static final int SIDE = 20;
    private static final int PATTERN_HEIGHT = 30;
    private static final int PATTERN_WIDTH = 15;
    private static final int PATTERN_MARGIN = 3;
    private static final int PATTERN_COLUMNS = 8;
    private static final int PATTERN_ROWS = 4;
    private static final ResourceKey[][] EXCLUSION = new ResourceKey[][]{{BannerPatterns.GRADIENT, BannerPatterns.GRADIENT_UP}, {BannerPatterns.BRICKS, BannerPatterns.FLOWER}, {BannerPatterns.SKULL, BannerPatterns.CREEPER}, {BannerPatterns.GLOBE, BannerPatterns.PIGLIN}, {BannerPatterns.MOJANG}, {BannerPatterns.BASE}};
    private final List<Holder<BannerPattern>> patterns;
    private final List<BannerPatternLayers.Layer> layers;
    private final IColonyView colony;
    private final AbstractWindowTownHall window;
    private final ModelPart modelRender;
    private final AtomicBoolean isFeatureUnlocked;
    private ColorPalette colors;
    private int activeLayer = 0;
    private boolean scrolling = false;
    private int scrollRow = 0;

    public WindowBannerPicker(IColonyView colony, AbstractWindowTownHall hallWindow, AtomicBoolean isFeatureUnlocked) {
        super((Component)Component.literal((String)"Flag"));
        this.colony = colony;
        this.window = hallWindow;
        this.modelRender = Minecraft.getInstance().getEntityModels().bakeLayer(ModelLayers.BANNER).getChild("flag");
        ArrayList exclusion = new ArrayList();
        for (int i = ((ITownHallView)hallWindow.building).getBuildingLevel(); i <= ((ITownHallView)hallWindow.building).getBuildingMaxLevel(); ++i) {
            for (ResourceKey key : EXCLUSION[i]) {
                exclusion.add(Utils.getRegistryValue(key, colony.getWorld()));
            }
        }
        this.patterns = ((Registry)colony.getWorld().registryAccess().registry(Registries.BANNER_PATTERN).get()).holders().collect(Collectors.toCollection(LinkedList::new));
        this.patterns.removeAll(exclusion);
        this.isFeatureUnlocked = isFeatureUnlocked;
        this.layers = new ArrayList<BannerPatternLayers.Layer>(colony.getColonyFlag().layers());
    }

    protected void init() {
        int paletteX = WindowBannerPicker.center(this.width, 8, 15, 0, 0) - 70;
        this.colors = new ColorPalette(paletteX, this.height / 2, 2, x$0 -> {
            Button cfr_ignored_0 = (Button)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.colors.onchange = color -> this.setLayer(null, color);
        this.createLayerButtons();
        this.createPatternButtons();
        this.createCloseButtons();
    }

    protected void createLayerButtons() {
        for (int layer = 0; layer <= 6; ++layer) {
            int posX = (this.width - 120) / 2 + layer * 20;
            this.addRenderableWidget((GuiEventListener)new LayerButton(posX, 30, 20, 20, layer));
        }
        this.addRenderableWidget((GuiEventListener)new Button(WindowBannerPicker.center(this.width, 6, 20, 7, 0), 30, 20, 20, (Component)Component.literal((String)(String.valueOf(ChatFormatting.RED) + "X")), pressed -> this.layers.remove(this.activeLayer), Button.DEFAULT_NARRATION){

            public void renderWidget(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
                this.active = WindowBannerPicker.this.activeLayer < WindowBannerPicker.this.layers.size() && WindowBannerPicker.this.activeLayer != 0;
                super.renderWidget(stack, mouseX, mouseY, partialTicks);
            }
        });
    }

    protected void createPatternButtons() {
        for (int i = 0; i < this.patterns.size(); ++i) {
            int posX = WindowBannerPicker.center(this.width, 8, 15, i % 8, 3);
            int posY = WindowBannerPicker.center(this.height + 30, 4, 30, Math.floorDiv(i, 8), 3);
            PatternButton button = new PatternButton(posX, posY, 30, this.patterns.get(i));
            this.addRenderableWidget((GuiEventListener)button);
            if (this.isFeatureUnlocked.get() || !((ResourceKey)this.patterns.get(i).unwrapKey().get()).location().getNamespace().equals("minecolonies")) continue;
            button.setTooltip(Tooltip.create((Component)Component.translatable((String)"com.minecolonies.core.gui.banner.patreon")));
            button.blocked = true;
        }
    }

    protected void createCloseButtons() {
        this.addRenderableWidget((GuiEventListener)new Button(WindowBannerPicker.center(this.width, 2, 80, 1, 10), this.height - 40, 80, 20, (Component)Component.translatableEscape((String)"gui.done", (Object[])new Object[0]), pressed -> {
            BannerPatternLayers.Builder builder = new BannerPatternLayers.Builder();
            for (BannerPatternLayers.Layer layer : this.layers) {
                builder.add(layer);
            }
            this.colony.setColonyFlag(builder.build());
            this.window.open();
        }, Button.DEFAULT_NARRATION));
        this.addRenderableWidget((GuiEventListener)new Button(WindowBannerPicker.center(this.width, 2, 80, 0, 10), this.height - 40, 80, 20, (Component)Component.translatableEscape((String)"gui.cancel", (Object[])new Object[0]), pressed -> this.window.open(), Button.DEFAULT_NARRATION));
    }

    public static int center(int length, int count, int side, int n, int margin) {
        return (length - count * (side + margin)) / 2 + n * (side + margin) + margin / 2;
    }

    public void setLayer(@Nullable Holder<BannerPattern> pattern, DyeColor color) {
        if (pattern == null) {
            if (this.activeLayer == this.layers.size()) {
                return;
            }
            pattern = this.activeLayer == 0 ? Utils.getRegistryValue(BannerPatterns.BASE, this.colony.getWorld()) : this.layers.get(this.activeLayer).pattern();
        }
        if (this.activeLayer == this.layers.size()) {
            this.layers.add(new BannerPatternLayers.Layer(pattern, color));
        } else {
            this.layers.set(this.activeLayer, new BannerPatternLayers.Layer(pattern, color));
        }
    }

    public void render(GuiGraphics stack, int mouseX, int mouseY, float partialTicks) {
        super.render(stack, mouseX, mouseY, partialTicks);
        this.drawFlag(stack);
        int scrollRows = (int)(Math.ceil((float)this.patterns.size() / 8.0f) - 4.0);
        if (scrollRows > 0 && this.activeLayer > 0) {
            int trackHeight = 132;
            double barHeight = (float)trackHeight * (4.0f / (float)(scrollRows + 4));
            int trackX = WindowBannerPicker.center(this.width, 8, 15, 8, 3);
            int trackY = (int)((float)WindowBannerPicker.center(this.height, 4, 30, 0, 3) + (float)this.scrollRow * ((float)trackHeight / (float)(scrollRows + 4)));
            stack.fill(trackX + 2, trackY, trackX + 6, trackY + (int)barHeight, -1140850689);
        }
        stack.drawCenteredString(this.font, Component.translatableEscape((String)"com.minecolonies.coremod.gui.flag.choose", (Object[])new Object[0]).getString(), this.width / 2, 16, 0xFFFFFF);
    }

    private void drawFlag(GuiGraphics stack) {
        Lighting.setupForFlatItems();
        double posX = ((double)this.width + 120.0) / 2.0 + 40.0;
        double posY = (double)this.height / 2.0;
        PoseStack transform = new PoseStack();
        transform.translate(posX, posY + 40.0, 0.0);
        transform.scale(40.0f, -40.0f, 1.0f);
        transform.translate(0.5, 0.5, 0.5);
        transform.scale(1.0f, -1.0f, -1.0f);
        this.renderBanner(transform, this.layers, stack);
    }

    private void drawBannerPattern(Holder<BannerPattern> pattern, int x, int y, GuiGraphics stack) {
        Lighting.setupForFlatItems();
        ArrayList<BannerPatternLayers.Layer> list = new ArrayList<BannerPatternLayers.Layer>();
        list.add(new BannerPatternLayers.Layer(Utils.getRegistryValue(BannerPatterns.BASE, this.colony.getWorld()), DyeColor.GRAY));
        if (!this.isFeatureUnlocked.get() && ((ResourceKey)pattern.unwrapKey().get()).location().getNamespace().equals("minecolonies")) {
            list.add(new BannerPatternLayers.Layer(pattern, DyeColor.BLACK));
        } else {
            list.add(new BannerPatternLayers.Layer(pattern, DyeColor.WHITE));
        }
        PoseStack transform = new PoseStack();
        transform.pushPose();
        transform.translate((double)x + 2.5, (double)(y + 29), 0.0);
        transform.scale(10.0f, -11.0f, 1.0f);
        transform.translate(0.5, 0.5, 0.5);
        transform.scale(1.0f, -1.0f, -1.0f);
        this.renderBanner(transform, list, stack);
    }

    public void renderBanner(PoseStack transform, List<BannerPatternLayers.Layer> layers, GuiGraphics stack) {
        this.modelRender.xRot = 0.0f;
        this.modelRender.y = -32.0f;
        BannerPatternLayers.Builder builder = new BannerPatternLayers.Builder();
        for (BannerPatternLayers.Layer layer : layers) {
            builder.add(layer);
        }
        BannerRenderer.renderPatterns((PoseStack)transform, (MultiBufferSource)stack.bufferSource(), (int)0xF000F0, (int)OverlayTexture.NO_OVERLAY, (ModelPart)this.modelRender, (Material)ModelBakery.BANNER_BASE, (boolean)true, (DyeColor)this.colors.getSelected(), (BannerPatternLayers)builder.build());
        transform.popPose();
        stack.flush();
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.activeLayer > 0) {
            this.scrollRow = (int)Mth.clamp((double)((double)this.scrollRow - scrollY), (double)0.0, (double)(Math.ceil(this.patterns.size() / 8) - 4.0 + 1.0));
        }
        return true;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int p_231044_5_) {
        this.scrolling = false;
        int trackX = WindowBannerPicker.center(this.width, 8, 15, 8, 3);
        int trackY = WindowBannerPicker.center(this.height, 4, 30, 0, 3);
        int trackEnd = trackY + 132;
        if (mouseX > (double)(trackX + 2) && mouseX < (double)(trackX + 8) && mouseY > (double)trackY && mouseY < (double)trackEnd) {
            this.scrolling = true;
        }
        return super.mouseClicked(mouseX, mouseY, p_231044_5_);
    }

    public boolean mouseDragged(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        if (this.scrolling && this.activeLayer > 0) {
            int trackStart = WindowBannerPicker.center(this.height, 4, 30, 0, 3);
            int trackLength = 132;
            double scrollRatio = Mth.clamp((double)((mouseY - (double)trackStart) / (double)trackLength), (double)0.0, (double)1.0);
            this.scrollRow = (int)Math.round(scrollRatio * (Math.ceil(this.patterns.size() / 8) - 4.0 + 1.0));
            return true;
        }
        return super.mouseDragged(mouseX, mouseY, button, deltaX, deltaY);
    }

    public class LayerButton
    extends Button {
        private final int layer;

        public LayerButton(int x, int y, int width, int height, int layer) {
            super(x - (layer == 0 ? width * 2 : 0), y, width * (layer == 0 ? 3 : 1), height, (Component)(layer == 0 ? Component.translatableEscape((String)"com.minecolonies.coremod.gui.flag.base_layer", (Object[])new Object[0]) : Component.literal((String)String.valueOf(layer))), pressed -> {}, DEFAULT_NARRATION);
            this.layer = layer;
        }

        public void onPress() {
            WindowBannerPicker.this.activeLayer = this.layer;
            if (this.layer >= WindowBannerPicker.this.layers.size()) {
                WindowBannerPicker.this.colors.setSelected(WindowBannerPicker.this.layers.get(0).color().equals((Object)DyeColor.BLACK) ? DyeColor.WHITE : DyeColor.BLACK);
            } else {
                WindowBannerPicker.this.colors.setSelected(WindowBannerPicker.this.layers.get(WindowBannerPicker.this.activeLayer).color());
            }
        }

        public void renderWidget(GuiGraphics stack, int p_render_1_, int p_render_2_, float p_render_3_) {
            this.active = this.layer <= WindowBannerPicker.this.layers.size();
            super.renderWidget(stack, p_render_1_, p_render_2_, p_render_3_);
            if (WindowBannerPicker.this.activeLayer == this.layer) {
                stack.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 1725798911);
            }
        }
    }

    public class PatternButton
    extends Button {
        private final Holder<BannerPattern> pattern;
        private int index;
        private boolean blocked;

        public PatternButton(int x, int y, int height, Holder<BannerPattern> pattern) {
            super(x, y, height / 2, height, (Component)Component.literal((String)""), btn -> {}, DEFAULT_NARRATION);
            this.index = -1;
            this.blocked = false;
            this.pattern = pattern;
            int tempIndex = 0;
            for (Holder<BannerPattern> pat : WindowBannerPicker.this.patterns) {
                if (((BannerPattern)pat.value()).assetId().equals((Object)((BannerPattern)pattern.value()).assetId())) {
                    this.index = tempIndex;
                    break;
                }
                ++tempIndex;
            }
        }

        public void onPress() {
            if (!this.blocked) {
                WindowBannerPicker.this.setLayer(this.pattern, WindowBannerPicker.this.colors.getSelected());
            }
        }

        public void renderWidget(GuiGraphics stack, int mx, int my, float p_renderButton_3_) {
            boolean isVisible = WindowBannerPicker.this.scrollRow * 8 <= this.index && this.index < 8 * (WindowBannerPicker.this.scrollRow + 4);
            boolean bl = this.active = WindowBannerPicker.this.activeLayer != 0;
            if (!(this.active && this.visible && isVisible)) {
                return;
            }
            int position = Math.floorDiv(this.index - WindowBannerPicker.this.scrollRow * 8, 8);
            this.setY(WindowBannerPicker.center(WindowBannerPicker.this.height, 4, 30, position, 3));
            this.isHovered = mx >= this.getX() && my >= this.getY() && mx < this.getX() + this.width && my < this.getY() + this.height;
            super.renderWidget(stack, mx, my, p_renderButton_3_);
            if (isVisible) {
                if (this.blocked) {
                    stack.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -16777216);
                } else if (this.visible) {
                    if (this.isHovered && this.active) {
                        stack.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -570425345);
                    }
                    if (WindowBannerPicker.this.activeLayer < WindowBannerPicker.this.layers.size() && WindowBannerPicker.this.layers.get(WindowBannerPicker.this.activeLayer).pattern() == this.pattern) {
                        stack.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, -2258689);
                    } else {
                        stack.fill(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height, 0x33888888);
                    }
                }
            }
            try {
                WindowBannerPicker.this.drawBannerPattern(this.pattern, this.getX(), this.getY(), stack);
            }
            catch (Exception ex) {
                Log.getLogger().warn(((BannerPattern)this.pattern.value()).translationKey());
                Log.getLogger().error((Object)ex);
            }
        }
    }
}

