/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesGrave;
import com.minecolonies.api.blocks.types.GraveType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.tileentities.AbstractTileEntityGrave;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.tileentities.TileEntityGrave;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class BlockMinecoloniesGrave
extends AbstractBlockMinecoloniesGrave<BlockMinecoloniesGrave> {
    private static final float BLOCK_HARDNESS = 1.5f;
    private static final String BLOCK_NAME = "blockminecoloniesgrave";
    private static final float RESISTANCE = 5.0f;
    private static final VoxelShape SHAPE = Shapes.box((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);

    public BlockMinecoloniesGrave() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(1.5f, 5.0f));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)VARIANT, (Comparable)((Object)GraveType.DEFAULT)));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    public boolean propagatesSkylightDown(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return false;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level worldIn = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = this.defaultBlockState();
        BlockEntity entity = worldIn.getBlockEntity(pos);
        if (!(entity instanceof TileEntityGrave)) {
            return super.getStateForPlacement(context);
        }
        return BlockMinecoloniesGrave.getPlacementState(state, pos);
    }

    public static BlockState getPlacementState(BlockState state, BlockPos pos) {
        return (BlockState)state.setValue((Property)VARIANT, (Comparable)((Object)GraveType.DEFAULT));
    }

    @Deprecated
    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public void spawnAfterBreak(BlockState state, ServerLevel worldIn, BlockPos pos, ItemStack stack, boolean p_222953_) {
        BlockEntity tileentity = worldIn.getBlockEntity(pos);
        if (tileentity instanceof TileEntityGrave) {
            IItemHandlerModifiable handler = ((AbstractTileEntityGrave)tileentity).getInventory();
            InventoryUtils.dropItemHandler((IItemHandler)handler, (Level)worldIn, pos.getX(), pos.getY(), pos.getZ());
        }
        super.spawnAfterBreak(state, worldIn, pos, stack, p_222953_);
    }

    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos);
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if ((colony == null || colony.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) && tileEntity instanceof TileEntityGrave) {
            TileEntityGrave grave = (TileEntityGrave)tileEntity;
            if (!worldIn.isClientSide) {
                ((ServerPlayer)player).openMenu((MenuProvider)grave, buf -> buf.writeBlockPos(grave.getBlockPos()));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState tempState = state;
        tempState = (BlockState)tempState.setValue((Property)VARIANT, (Comparable)((Object)GraveType.DEFAULT));
        if (placer != null) {
            tempState = (BlockState)tempState.setValue((Property)FACING, (Comparable)placer.getDirection().getOpposite());
        }
        worldIn.setBlock(pos, tempState, 2);
    }

    public VoxelShape getCollisionShape(BlockState p_60572_, BlockGetter p_60573_, BlockPos p_60574_, CollisionContext p_60575_) {
        return Shapes.empty();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VARIANT});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityGrave(blockPos, blockState);
    }

    public void onRemove(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = worldIn.getBlockEntity(pos);
            if (tileEntity instanceof TileEntityGrave) {
                TileEntityGrave tileEntityGrave = (TileEntityGrave)tileEntity;
                InventoryUtils.dropItemHandler((IItemHandler)tileEntityGrave.getInventory(), worldIn, tileEntityGrave.getBlockPos().getX(), tileEntityGrave.getBlockPos().getY(), tileEntityGrave.getBlockPos().getZ());
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }
}

