/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.google.gson.JsonElement;
import com.minecolonies.api.util.Log;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.nio.file.Path;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;

public final class Utils {
    private static final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();

    private Utils() {
    }

    public static boolean isBlockInRange(@NotNull Level world, Block block, int posX, int posY, int posZ, int range) {
        for (int x = posX - range; x < posX + range; ++x) {
            for (int z = posZ - range; z < posZ + range; ++z) {
                for (int y = posY - range; y < posY + range; ++y) {
                    if (!Objects.equals(world.getBlockState(new BlockPos(x, y, z)).getBlock(), block)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static String[] splitPath(String path) {
        if (path.contains("\\")) {
            return path.split("\\\\");
        }
        return path.split("/");
    }

    public static Path resolvePath(Path path, String subPath) {
        Path resultPath = path;
        for (String sub : Utils.splitPath(subPath)) {
            resultPath = resultPath.resolve(sub);
        }
        return resultPath;
    }

    public static boolean testFlag(long data, long flag) {
        return Utils.mask(data, flag) == flag;
    }

    public static long mask(long data, long mask) {
        return data & mask;
    }

    public static long setFlag(long data, long flag) {
        return data | flag;
    }

    public static long unsetFlag(long data, long flag) {
        return data & (flag ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static long toggleFlag(long data, long flag) {
        return data ^ flag;
    }

    public static void checkDirectory(@NotNull File directory) {
        if (!directory.exists() && !directory.mkdirs()) {
            Log.getLogger().error("Directory doesn't exist and failed to be created: " + directory.toString());
        }
    }

    public static String format(long value) {
        if (value == Long.MIN_VALUE) {
            return Utils.format(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + Utils.format(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        Map.Entry<Long, String> e = suffixes.floorEntry(value);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = value / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    public static int getBlueprintLevel(String schematicName) {
        String string;
        Matcher matcher = Pattern.compile("[0-9]$").matcher(schematicName.replace(".blueprint", ""));
        if (matcher.find() && !(string = matcher.group()).isEmpty()) {
            try {
                return Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    public static <T> Holder<T> getRegistryValue(ResourceKey<T> resourceKey, Level level) {
        return level.holderOrThrow(resourceKey);
    }

    public static <T> Tag serializeCodecMess(Codec<T> codec, HolderLookup.Provider provider, T obj) {
        return (Tag)codec.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), obj).getOrThrow();
    }

    public static <T> T deserializeCodecMess(Codec<T> codec, HolderLookup.Provider provider, Tag tag) {
        return codec.parse((DynamicOps)provider.createSerializationContext((DynamicOps)NbtOps.INSTANCE), (Object)tag).resultOrPartial(res -> Log.getLogger().error("Failed to parse thing: '{}'", res)).get();
    }

    public static <T> JsonElement serializeCodecMessToJson(Codec<T> codec, HolderLookup.Provider provider, T obj) {
        return (JsonElement)codec.encodeStart((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), obj).getOrThrow();
    }

    public static <T> T deserializeCodecMessFromJson(Codec<T> codec, HolderLookup.Provider provider, JsonElement tag) {
        return codec.parse((DynamicOps)provider.createSerializationContext((DynamicOps)JsonOps.INSTANCE), (Object)tag).resultOrPartial(res -> Log.getLogger().error("Failed to parse thing: '{}'", res)).get();
    }

    public static <T> void serializeCodecMess(StreamCodec<RegistryFriendlyByteBuf, T> codec, RegistryFriendlyByteBuf buf, T obj) {
        codec.encode((Object)buf, obj);
    }

    public static <T> T deserializeCodecMess(StreamCodec<RegistryFriendlyByteBuf, T> codec, RegistryFriendlyByteBuf buf) {
        return (T)codec.decode((Object)buf);
    }

    public static void serializeCodecMess(RegistryFriendlyByteBuf buf, ItemStack obj) {
        ItemStack.OPTIONAL_STREAM_CODEC.encode((Object)buf, (Object)obj);
    }

    public static ItemStack deserializeCodecMess(RegistryFriendlyByteBuf buf) {
        return (ItemStack)ItemStack.OPTIONAL_STREAM_CODEC.decode((Object)buf);
    }

    static {
        suffixes.put(1000L, "k");
        suffixes.put(1000000L, "M");
        suffixes.put(1000000000L, "G");
        suffixes.put(1000000000000L, "T");
        suffixes.put(1000000000000000L, "P");
        suffixes.put(1000000000000000000L, "E");
    }
}

