/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.google.gson.JsonParser;
import com.minecolonies.api.advancements.AdvancementTriggers;
import com.minecolonies.api.advancements.CitizenEatFoodTrigger;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.happiness.ExpirationBasedHappinessModifier;
import com.minecolonies.api.entity.citizen.happiness.StaticHappinessSupplier;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.IMinecoloniesFoodItem;
import com.minecolonies.api.items.ModItems;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.util.AdvancementUtils;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BrewingStandBlockEntity;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.crafting.SizedIngredient;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ItemStackUtils {
    private static final Pattern TEMPLATE_PATH_PATTERN = Pattern.compile("\\[PATH(?::([^=]*)=([^]]*))?]");
    private static final Map<Item, Integer> VANILLA_ARMOR_DISTRIBUTION = Map.ofEntries(Map.entry(Items.LEATHER_HELMET, 1), Map.entry(Items.LEATHER_CHESTPLATE, 1), Map.entry(Items.LEATHER_LEGGINGS, 1), Map.entry(Items.LEATHER_BOOTS, 1), Map.entry(Items.GOLDEN_HELMET, 1), Map.entry(Items.GOLDEN_CHESTPLATE, 1), Map.entry(Items.GOLDEN_LEGGINGS, 1), Map.entry(Items.GOLDEN_BOOTS, 1), Map.entry(Items.CHAINMAIL_HELMET, 2), Map.entry(Items.CHAINMAIL_CHESTPLATE, 2), Map.entry(Items.CHAINMAIL_LEGGINGS, 2), Map.entry(Items.CHAINMAIL_BOOTS, 2), Map.entry(Items.IRON_HELMET, 3), Map.entry(Items.IRON_CHESTPLATE, 3), Map.entry(Items.IRON_LEGGINGS, 3), Map.entry(Items.IRON_BOOTS, 3), Map.entry(Items.DIAMOND_HELMET, 4), Map.entry(Items.DIAMOND_CHESTPLATE, 4), Map.entry(Items.DIAMOND_LEGGINGS, 4), Map.entry(Items.DIAMOND_BOOTS, 4), Map.entry(Items.NETHERITE_HELMET, 5), Map.entry(Items.NETHERITE_CHESTPLATE, 5), Map.entry(Items.NETHERITE_LEGGINGS, 5), Map.entry(Items.NETHERITE_BOOTS, 5));
    private static final Map<EquipmentSlot, List<Item>> VANILLA_ARMOR_MAPPING = Map.ofEntries(Map.entry(EquipmentSlot.HEAD, List.of(Items.LEATHER_HELMET, Items.CHAINMAIL_HELMET, Items.IRON_HELMET, Items.DIAMOND_HELMET)), Map.entry(EquipmentSlot.CHEST, List.of(Items.LEATHER_CHESTPLATE, Items.CHAINMAIL_CHESTPLATE, Items.IRON_CHESTPLATE, Items.DIAMOND_CHESTPLATE)), Map.entry(EquipmentSlot.LEGS, List.of(Items.LEATHER_LEGGINGS, Items.CHAINMAIL_LEGGINGS, Items.IRON_LEGGINGS, Items.DIAMOND_LEGGINGS)), Map.entry(EquipmentSlot.FEET, List.of(Items.LEATHER_BOOTS, Items.CHAINMAIL_BOOTS, Items.IRON_BOOTS, Items.DIAMOND_BOOTS)));
    public static final ItemStack EMPTY = ItemStack.EMPTY;
    @NotNull
    public static final Predicate<ItemStack> EMPTY_PREDICATE = ItemStackUtils::isEmpty;
    @NotNull
    public static final Predicate<ItemStack> NOT_EMPTY_PREDICATE = EMPTY_PREDICATE.negate();
    public static HashMap<Item, Set<DataComponentType<?>>> CHECKED_NBT_KEYS = new HashMap();
    public static final Predicate<ItemStack> IS_ANY_FOOD = stack -> {
        FoodProperties foodProperties = stack.getFoodProperties(null);
        return ItemStackUtils.isNotEmpty(stack) && foodProperties != null && foodProperties.nutrition() > 0 && foodProperties.saturation() > 0.0f;
    };
    public static final Predicate<ItemStack> ISFOOD = stack -> IS_ANY_FOOD.test((ItemStack)stack) && !stack.is(ModTags.excludedFood);
    public static Predicate<ItemStack> IS_SMELTABLE = itemStack -> !ItemStackUtils.isEmpty(IColonyManager.getInstance().getCompatibilityManager().getFurnaceRecipes().getSmeltingResult((ItemStack)itemStack));
    public static Predicate<ItemStack> ISCOOKABLE = itemStack -> ISFOOD.test(IColonyManager.getInstance().getCompatibilityManager().getFurnaceRecipes().getSmeltingResult((ItemStack)itemStack));
    public static final Predicate<ItemStack> IS_COMPOST = stack -> !stack.isEmpty() && stack.getItem() == ModItems.compost;

    private ItemStackUtils() {
    }

    public static List<ItemStorage> getListOfStackForEntity(Entity entity, Entity placer) {
        if (entity != null) {
            ArrayList<ItemStorage> request = new ArrayList<ItemStorage>();
            if (entity instanceof ItemFrame) {
                ItemStack stack2 = ((ItemFrame)entity).getItem();
                if (!ItemStackUtils.isEmpty(stack2)) {
                    ItemStackUtils.setSize(stack2, 1);
                    request.add(new ItemStorage(stack2));
                }
                request.add(new ItemStorage(new ItemStack((ItemLike)Items.ITEM_FRAME, 1)));
            } else if (entity instanceof ArmorStand) {
                request.add(new ItemStorage(entity.getPickedResult((HitResult)new EntityHitResult(placer))));
                ((ArmorStand)entity).getArmorSlots().forEach(item -> request.add(new ItemStorage((ItemStack)item)));
                ((ArmorStand)entity).getHandSlots().forEach(item -> request.add(new ItemStorage((ItemStack)item)));
            }
            return request.stream().filter(stack -> !stack.getItemStack().isEmpty()).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static boolean hasEquipmentLevel(@Nullable ItemStack stack, EquipmentTypeEntry equipmentType, int minimalLevel, int maximumLevel) {
        if (ItemStackUtils.isEmpty(stack)) {
            return false;
        }
        return equipmentType.checkIsEquipment(stack) && ItemStackUtils.verifyEquipmentLevel(stack, equipmentType.getMiningLevel(stack), minimalLevel, maximumLevel);
    }

    public static boolean isEmpty(@Nullable ItemStack stack) {
        return stack == null || stack.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable ItemStack stack) {
        return !ItemStackUtils.isEmpty(stack);
    }

    public static boolean verifyEquipmentLevel(@NotNull ItemStack itemStack, int equipmentLevel, int minimalLevel, int maximumLevel) {
        if (equipmentLevel < minimalLevel) {
            return false;
        }
        return equipmentLevel + ItemStackUtils.getMaxEnchantmentLevel(itemStack) <= maximumLevel;
    }

    public static int getMaxEnchantmentLevel(ItemStack itemStack) {
        if (itemStack == null) {
            return 0;
        }
        int maxLevel = 0;
        for (Object2IntMap.Entry entry : itemStack.getTagEnchantments().entrySet()) {
            int level = entry.getIntValue();
            maxLevel = Math.max(level, maxLevel);
        }
        return Math.max(maxLevel - 1, 0);
    }

    public static int getArmorLevel(ItemStack itemStack) {
        Integer value = VANILLA_ARMOR_DISTRIBUTION.get(itemStack.getItem());
        if (value != null) {
            return value;
        }
        EquipmentSlot targetEquipmentSlot = Optional.ofNullable(Equipable.get((ItemStack)itemStack)).map(Equipable::getEquipmentSlot).orElse(EquipmentSlot.MAINHAND);
        List<Item> armorItems = VANILLA_ARMOR_MAPPING.get(targetEquipmentSlot);
        if (armorItems == null) {
            return 5;
        }
        double targetArmorLevel = ItemStackUtils.getArmorValue(itemStack, targetEquipmentSlot);
        for (Item item : armorItems) {
            ArmorItem armorItem;
            double armorValue;
            if (!(item instanceof ArmorItem) || !(targetArmorLevel <= (armorValue = ItemStackUtils.getArmorValue((armorItem = (ArmorItem)item).getDefaultInstance(), armorItem.getEquipmentSlot())))) continue;
            return VANILLA_ARMOR_DISTRIBUTION.get(armorItem);
        }
        return 5;
    }

    private static double getArmorValue(ItemStack itemStack, EquipmentSlot equipmentSlot) {
        double armor = ItemStackUtils.getItemStackAttributeValue(itemStack, equipmentSlot, (Holder<Attribute>)Attributes.ARMOR);
        double toughness = ItemStackUtils.getItemStackAttributeValue(itemStack, equipmentSlot, (Holder<Attribute>)Attributes.ARMOR_TOUGHNESS);
        return armor + toughness * 4.0;
    }

    public static boolean isBetterEquipment(ItemStack stack1, ItemStack stack2) {
        for (EquipmentTypeEntry equipmentType : ModEquipmentTypes.getRegistry()) {
            if (!equipmentType.checkIsEquipment(stack1) || !equipmentType.checkIsEquipment(stack2) || equipmentType.getMiningLevel(stack1) <= equipmentType.getMiningLevel(stack2)) continue;
            return true;
        }
        return false;
    }

    public static int getFortuneOf(@Nullable ItemStack tool, Level level) {
        if (tool == null) {
            return 0;
        }
        int fortune = 0;
        if (tool.isEnchanted()) {
            return tool.getTagEnchantments().getLevel(Utils.getRegistryValue(Enchantments.FORTUNE, level));
        }
        return fortune;
    }

    public static boolean doesItemServeAsWeapon(@NotNull ItemStack stack) {
        return stack.getItem() instanceof SwordItem || stack.getItem() instanceof DiggerItem || Compatibility.isTinkersWeapon(stack);
    }

    public static MutableComponent swapArmorGrade(int toolGrade) {
        if (toolGrade >= 0 && toolGrade <= 4) {
            return Component.translatableEscape((String)("com.minecolonies.coremod.armorlevel." + toolGrade), (Object[])new Object[0]);
        }
        return Component.translatableEscape((String)"com.minecolonies.coremod.armorlevel.etc", (Object[])new Object[0]);
    }

    public static MutableComponent swapToolGrade(int toolGrade) {
        if (toolGrade >= 0 && toolGrade <= 4) {
            return Component.translatableEscape((String)("com.minecolonies.coremod.toollevel." + toolGrade), (Object[])new Object[0]);
        }
        return Component.translatableEscape((String)"com.minecolonies.coremod.toollevel.etc", (Object[])new Object[0]);
    }

    @NotNull
    public static Boolean areItemStacksMergable(ItemStack existingStack, ItemStack mergingStack) {
        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(existingStack, mergingStack).booleanValue()) {
            return false;
        }
        return existingStack.getMaxStackSize() >= ItemStackUtils.getSize(existingStack) + ItemStackUtils.getSize(mergingStack);
    }

    @NotNull
    public static Boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, true, true);
    }

    public static int getSize(@NotNull ItemStack stack) {
        return stack.getCount();
    }

    public static int getDurability(@NotNull ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return 0;
        }
        return stack.getMaxDamage() - stack.getDamageValue();
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min) {
        return ItemStackUtils.compareItemStacksIgnoreStackSize(itemStack1, itemStack2, matchDamage, matchNBT, false, false);
    }

    public static boolean compareItemStacksIgnoreStackSize(ItemStack itemStack1, ItemStack itemStack2, boolean matchDamage, boolean matchNBT, boolean min, boolean matchNBTExactly) {
        if (ItemStackUtils.isEmpty(itemStack1) && ItemStackUtils.isEmpty(itemStack2)) {
            return true;
        }
        if (ItemStackUtils.isEmpty(itemStack1) != ItemStackUtils.isEmpty(itemStack2)) {
            return false;
        }
        if (!(itemStack1.getItem() != itemStack2.getItem() || matchDamage && itemStack1.getDamageValue() != itemStack2.getDamageValue())) {
            if (!matchNBT) {
                return true;
            }
            if (min && itemStack1.getCount() > itemStack2.getCount()) {
                return false;
            }
            if (matchNBTExactly) {
                return ItemStack.isSameItemSameComponents((ItemStack)itemStack1, (ItemStack)itemStack2);
            }
            Set<DataComponentType<?>> checkedKeys = CHECKED_NBT_KEYS.get(itemStack1.getItem());
            if (checkedKeys == null || checkedKeys.isEmpty()) {
                return true;
            }
            for (DataComponentType<?> key : checkedKeys) {
                if (Objects.equals(itemStack1.getComponents().get(key), itemStack2.getComponents().get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack) {
        return ItemStackUtils.compareItemStackListIgnoreStackSize(stacks, stack, true, true);
    }

    public static boolean compareItemStackListIgnoreStackSize(List<ItemStack> stacks, ItemStack stack, boolean matchDamage, boolean matchNBT) {
        for (ItemStack tempStack : stacks) {
            if (!ItemStackUtils.compareItemStacksIgnoreStackSize(tempStack, stack, matchDamage, matchNBT)) continue;
            return true;
        }
        return false;
    }

    public static void setSize(@NotNull ItemStack stack, int size) {
        stack.setCount(size);
    }

    public static void changeSize(@NotNull ItemStack stack, int amount) {
        stack.setCount(stack.getCount() + amount);
    }

    @NotNull
    public static ItemStack deserializeFromNBT(@NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        return ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound);
    }

    public static boolean isStackSapling(@Nullable ItemStack stack) {
        if (ItemStackUtils.isEmpty(stack)) {
            return false;
        }
        return stack.is(ItemTags.SAPLINGS) || stack.is(Tags.Items.MUSHROOMS) || stack.is(ModTags.fungi) || Compatibility.isDynamicTreeSapling(stack);
    }

    public static boolean hasSmeltableInFurnaceAndNoFuel(FurnaceBlockEntity entity) {
        return !ItemStackUtils.isEmpty(entity.getItem(0)) && ItemStackUtils.isEmpty(entity.getItem(1));
    }

    public static boolean hasNeitherFuelNorSmeltAble(FurnaceBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.getItem(0)) && ItemStackUtils.isEmpty(entity.getItem(1));
    }

    public static boolean hasFuelInFurnaceAndNoSmeltable(FurnaceBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.getItem(0)) && !ItemStackUtils.isEmpty(entity.getItem(1));
    }

    public static boolean hasBrewableAndNoFuel(BrewingStandBlockEntity entity) {
        return !ItemStackUtils.isEmpty(entity.getItem(3)) && ItemStackUtils.isEmpty(entity.getItem(4));
    }

    public static boolean hasNeitherFuelNorBrewable(BrewingStandBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.getItem(3)) && ItemStackUtils.isEmpty(entity.getItem(4));
    }

    public static boolean hasFuelAndNoBrewable(BrewingStandBlockEntity entity) {
        return ItemStackUtils.isEmpty(entity.getItem(3)) && !ItemStackUtils.isEmpty(entity.getItem(4));
    }

    public static ItemStack idToItemStack(String itemData, HolderLookup.Provider provider) {
        Item item;
        String itemId = itemData;
        int tagIndex = itemId.indexOf("{");
        String tag = tagIndex > 0 ? itemId.substring(tagIndex) : null;
        itemId = tagIndex > 0 ? itemId.substring(0, tagIndex) : itemId;
        try {
            item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)itemId));
        }
        catch (Throwable t) {
            Log.getLogger().error("Unable to parse item definition: {}", (Object)itemData, (Object)t);
            return ItemStack.EMPTY;
        }
        ItemStack stack = new ItemStack((ItemLike)item);
        if (tag != null) {
            try {
                stack.applyComponents((DataComponentPatch)Utils.deserializeCodecMessFromJson(DataComponentPatch.CODEC, provider, JsonParser.parseString((String)tag)));
            }
            catch (Throwable t) {
                Log.getLogger().error("Unable to parse item definition: {}", (Object)itemData, (Object)t);
            }
        }
        if (stack.isEmpty()) {
            Log.getLogger().warn("Parsed item definition returned empty: {}", (Object)itemData);
        }
        return stack;
    }

    @NotNull
    public static Tuple<Boolean, String> parseIdTemplate(@Nullable String itemId, @NotNull ResourceLocation baseItemId) {
        if (itemId == null) {
            return new Tuple<Boolean, Object>(false, null);
        }
        itemId = itemId.replace("[NS]", baseItemId.getNamespace());
        itemId = TEMPLATE_PATH_PATTERN.matcher(itemId).replaceAll(m -> {
            if (m.group(1) != null && m.group(2) != null) {
                return baseItemId.getPath().replace(m.group(1), m.group(2));
            }
            return baseItemId.getPath();
        });
        return new Tuple<Boolean, String>(BuiltInRegistries.ITEM.containsKey(ResourceLocation.parse((String)itemId)), itemId);
    }

    public static boolean hasTag(@NotNull ItemStack stack) {
        return stack.getComponents() != null && stack.getComponents().size() > (stack.isDamageableItem() ? 1 : 0);
    }

    public static Set<ItemStack> allItemsPlusInventory(@NotNull Player player) {
        HashSet<ItemStorage> allItems = new HashSet<ItemStorage>(IColonyManager.getInstance().getCompatibilityManager().getSetOfAllItems());
        for (ItemStack stack : player.getInventory().items) {
            if (stack.isEmpty()) continue;
            ItemStack pristine = stack.copy();
            pristine.setCount(1);
            if (stack.isDamageableItem() && stack.isDamaged()) {
                pristine.setDamageValue(0);
            }
            allItems.add(new ItemStorage(pristine, true));
        }
        return allItems.stream().map(ItemStorage::getItemStack).collect(Collectors.toSet());
    }

    public static void consumeFood(ItemStack foodStack, AbstractEntityCitizen citizen, @Nullable Player player) {
        IColony citizenColony;
        IMinecoloniesFoodItem foodItem;
        Item item;
        ICitizenData citizenData = citizen.getCitizenData();
        double satIncrease = FoodUtils.getFoodValue(foodStack, citizen);
        citizenData.increaseSaturation(satIncrease);
        ItemStack itemUseReturn = FoodUtils.consumeFoodStack(foodStack, citizen);
        if (player != null && player.hasInfiniteMaterials()) {
            itemUseReturn = ItemStack.EMPTY;
        }
        if (!itemUseReturn.isEmpty()) {
            if (citizenData.getInventory().isFull() || player != null && !player.getInventory().add(itemUseReturn)) {
                InventoryUtils.spawnItemStack(citizen.level(), citizen.getX(), citizen.getY(), citizen.getZ(), itemUseReturn);
            } else {
                InventoryUtils.addItemStackToItemHandler((IItemHandler)citizenData.getInventory(), itemUseReturn);
            }
        }
        if ((item = foodStack.getItem()) instanceof IMinecoloniesFoodItem && (foodItem = (IMinecoloniesFoodItem)item).getTier() >= 3) {
            citizen.getCitizenData().getCitizenHappinessHandler().addModifier(new ExpirationBasedHappinessModifier("greatfood", 2.0, new StaticHappinessSupplier(2.0), 5));
        }
        if ((citizenColony = citizen.getCitizenColonyHandler().getColonyOrRegister()) != null) {
            AdvancementUtils.TriggerAdvancementPlayersForColony(citizenColony, playerMP -> ((CitizenEatFoodTrigger)((Object)((Object)AdvancementTriggers.CITIZEN_EAT_FOOD.get()))).trigger((ServerPlayer)playerMP, foodStack));
        }
        citizenData.markDirty(60);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static Component getTranslatedName(@NotNull SizedIngredient ingredient) {
        if (ingredient.ingredient().hasNoItems()) {
            return Component.empty();
        }
        ItemStack[] items = ingredient.getItems();
        Optional<TagKey<Item>> tag = ItemStackUtils.getTagEquivalent(items);
        return Component.translatable((String)"%sx %s", (Object[])new Object[]{ingredient.count(), tag.map(t -> {
            String standardKey = Tags.getTagTranslationKey((TagKey)t);
            String localKey = "com.minecolonies.coremod.research.tags." + String.valueOf(t.location());
            return I18n.exists((String)localKey) && !I18n.exists((String)standardKey) ? Component.translatable((String)localKey) : Component.translatable((String)"com.minecolonies.coremod.research.tags.other", (Object[])new Object[]{Component.translatableWithFallback((String)Tags.getTagTranslationKey((TagKey)t), (String)t.location().toString())});
        }).orElseGet(() -> {
            if (items.length == 1) {
                return items[0].getItem().getDescription();
            }
            return Component.translatable((String)String.join((CharSequence)"/", Collections.nCopies(items.length, "%s")), (Object[])Arrays.stream(items).map(ItemStack::getItem).map(Item::getDescription).toArray());
        })});
    }

    public static Optional<TagKey<Item>> getTagEquivalent(@NotNull ItemStack[] stacks) {
        List<Item> values = Arrays.stream(stacks).map(ItemStack::getItem).toList();
        if (values.size() <= 1) {
            return Optional.empty();
        }
        return BuiltInRegistries.ITEM.getTags().filter(e -> {
            HolderSet.Named tag = (HolderSet.Named)e.getSecond();
            return ItemStackUtils.areEquivalent((HolderSet.Named<Item>)tag, values);
        }).map(Pair::getFirst).findFirst();
    }

    private static boolean areEquivalent(@NotNull HolderSet.Named<Item> tag, @NotNull List<Item> values) {
        int count = tag.size();
        if (count != values.size()) {
            return false;
        }
        for (int i = 0; i < count; ++i) {
            Item tagValue = (Item)tag.get(i).value();
            Item value = values.get(i);
            if (value.equals(tagValue)) continue;
            return false;
        }
        return true;
    }

    public static double getItemStackAttributeValue(ItemStack itemStack, EquipmentSlot equipmentSlot, Holder<Attribute> attribute) {
        try {
            AttributeInstance instance = new AttributeInstance(attribute, f -> {});
            itemStack.getAttributeModifiers().forEach(equipmentSlot, (attr, modifier) -> {
                if (attr.equals((Object)attribute)) {
                    instance.addTransientModifier(modifier);
                }
            });
            return instance.getValue();
        }
        catch (Exception e) {
            Log.getLogger().warn("Could not get attribute value for '{}' on item '{}'", (Object)((Attribute)attribute.value()).getDescriptionId(), (Object)itemStack.getDescriptionId(), (Object)e);
            return 0.0;
        }
    }
}

