/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.tileentities;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.requestable.IDeliverable;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.IItemHandlerCapProvider;
import com.minecolonies.api.util.ItemStackUtils;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractTileEntityRack
extends BlockEntity
implements MenuProvider,
IItemHandlerCapProvider {
    protected boolean inWarehouse = false;
    protected BlockPos buildingPos = BlockPos.ZERO;
    protected ItemStackHandler inventory;

    public AbstractTileEntityRack(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
        this.inventory = this.createInventory(27);
    }

    public AbstractTileEntityRack(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state, int size) {
        super(tileEntityTypeIn, pos, state);
        this.inventory = this.createInventory(size);
    }

    public abstract ItemStackHandler createInventory(int var1);

    public void updateWarehouseIfAvailable(ItemStack stack) {
        if (!(ItemStackUtils.isEmpty(stack) || this.level == null || this.level.isClientSide || !this.inWarehouse && this.buildingPos.equals((Object)BlockPos.ZERO) || !IColonyManager.getInstance().isCoordinateInAnyColony(this.level, this.worldPosition))) {
            IColony colony = IColonyManager.getInstance().getClosestColony(this.level, this.worldPosition);
            if (colony == null) {
                return;
            }
            if (this.inWarehouse) {
                colony.getRequestManager().onColonyUpdate(request -> request.getRequest() instanceof IDeliverable && ((IDeliverable)request.getRequest()).matches(stack));
            } else {
                IBuilding building = colony.getBuildingManager().getBuilding(this.buildingPos);
                if (building != null) {
                    building.overruleNextOpenRequestWithStack(stack);
                    building.markDirty();
                }
            }
        }
    }

    public abstract void setInWarehouse(Boolean var1);

    public abstract int getFreeSlots();

    public abstract boolean hasItemStack(ItemStack var1, int var2, boolean var3);

    public abstract boolean hasItemStorage(ItemStorage var1, int var2);

    public abstract int getCount(ItemStack var1, boolean var2, boolean var3);

    public abstract int getCount(ItemStorage var1);

    public abstract boolean hasItemStack(@NotNull Predicate<ItemStack> var1);

    public abstract boolean hasSimilarStack(@NotNull ItemStack var1);

    public abstract void upgradeRackSize();

    public void setBuildingPos(BlockPos pos) {
        if (!(this.level == null || this.buildingPos != null && this.buildingPos.equals((Object)pos))) {
            this.setChanged();
        }
        this.buildingPos = pos;
    }

    public abstract int getUpgradeSize();

    public abstract int getItemCount(Predicate<ItemStack> var1);

    public abstract void updateItemStorage();

    protected abstract void updateBlockState();

    public abstract AbstractTileEntityRack getOtherChest();

    public abstract boolean isEmpty();

    public IItemHandlerModifiable getInventory() {
        return this.inventory;
    }

    public class RackInventory
    extends ItemStackHandler {
        public RackInventory(int defaultSize) {
            super(defaultSize);
        }

        protected void onContentsChanged(int slot) {
            AbstractTileEntityRack.this.updateItemStorage();
            super.onContentsChanged(slot);
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.validateSlotIndex(slot);
            boolean changed = !ItemStack.matches((ItemStack)stack, (ItemStack)((ItemStack)this.stacks.get(slot)));
            this.stacks.set(slot, (Object)stack);
            if (changed) {
                this.onContentsChanged(slot);
            }
            AbstractTileEntityRack.this.updateWarehouseIfAvailable(stack);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            ItemStack result = super.insertItem(slot, stack, simulate);
            if ((result.isEmpty() || result.getCount() < stack.getCount()) && !simulate) {
                AbstractTileEntityRack.this.updateWarehouseIfAvailable(stack);
            }
            return result;
        }
    }
}

