/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.inventory.container;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.inventory.ModContainers;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;

public class ContainerBuildingInventory
extends AbstractContainerMenu {
    private final IItemHandler buildingInventory;
    private final TileEntityColonyBuilding tileEntityColonyBuilding;
    private final int inventorySize;

    public static ContainerBuildingInventory fromFriendlyByteBuf(int windowId, Inventory inv, RegistryFriendlyByteBuf packetBuffer) {
        int colonyId = packetBuffer.readVarInt();
        BlockPos tePos = packetBuffer.readBlockPos();
        return new ContainerBuildingInventory(windowId, inv, colonyId, tePos);
    }

    public ContainerBuildingInventory(int windowId, final Inventory inv, final int colonyId, final BlockPos pos) {
        super((MenuType)ModContainers.buildingInv.get(), windowId);
        int i;
        this.tileEntityColonyBuilding = (TileEntityColonyBuilding)inv.player.level().getBlockEntity(pos);
        this.buildingInventory = this.tileEntityColonyBuilding.getInventory();
        int size = this.buildingInventory.getSlots();
        this.inventorySize = size / 9;
        int columns = this.inventorySize <= 8 ? 9 : size / 8 + 1;
        int extraOffset = this.inventorySize <= 8 ? 0 : 2;
        int index = 0;
        for (int j = 0; j < Math.min(this.inventorySize, 8); ++j) {
            for (int k = 0; k < columns; ++k) {
                if (index >= size) continue;
                this.addSlot((Slot)new SlotItemHandler(this, this.buildingInventory, index, 8 + k * 18, 18 + j * 18){

                    public void set(ItemStack stack) {
                        IColony colony;
                        IBuilding building;
                        super.set(stack);
                        if (!inv.player.level().isClientSide && !ItemStackUtils.isEmpty(stack) && (building = (colony = IColonyManager.getInstance().getColonyByWorld(colonyId, inv.player.level())).getBuildingManager().getBuilding(pos)) != null) {
                            building.overruleNextOpenRequestWithStack(stack);
                        }
                    }
                });
                ++index;
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inv, j + i * 9 + 9, 8 + j * 18, 30 + extraOffset + 18 * Math.min(this.inventorySize, 8) + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inv, i, 8 + i * 18, 88 + extraOffset + 18 * Math.min(this.inventorySize, 8)));
        }
    }

    public ItemStack quickMoveStack(Player playerIn, int index) {
        Slot slot = (Slot)this.slots.get(index);
        if (slot == null || !slot.hasItem()) {
            return ItemStackUtils.EMPTY;
        }
        ItemStack stackCopy = slot.getItem().copy();
        int maxIndex = this.inventorySize * 9;
        if (index < maxIndex ? !this.moveItemStackTo(stackCopy, maxIndex, this.slots.size(), true) : !this.moveItemStackTo(stackCopy, 0, maxIndex, false)) {
            return ItemStackUtils.EMPTY;
        }
        if (ItemStackUtils.getSize(stackCopy) == 0) {
            slot.set(ItemStackUtils.EMPTY);
        } else {
            slot.set(stackCopy);
        }
        return stackCopy;
    }

    public void removed(Player playerIn) {
        super.removed(playerIn);
    }

    public boolean stillValid(@NotNull Player playerIn) {
        return this.tileEntityColonyBuilding.isUsableByPlayer(playerIn);
    }

    public int getSize() {
        return this.inventorySize;
    }
}

