/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.equipment;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.apiimp.CommonMinecoloniesAPIImpl;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TieredItem;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModEquipmentTypes {
    public static final DeferredRegister<EquipmentTypeEntry> DEFERRED_REGISTER = DeferredRegister.create(CommonMinecoloniesAPIImpl.EQUIPMENT_TYPES, (String)"minecolonies");
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> none = ModEquipmentTypes.register("none", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.none")).setIsEquipment((itemStack, equipmentType) -> true).setEquipmentLevel((itemStack, equipmentType) -> -1).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> pickaxe = ModEquipmentTypes.register("pickaxe", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.pickaxe")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ItemAbilities.DEFAULT_PICKAXE_ACTIONS) || Compatibility.isTinkersTool(itemStack, equipmentType)).setEquipmentLevel(ModEquipmentTypes::vanillaToolLevel).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> shovel = ModEquipmentTypes.register("shovel", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.shovel")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ItemAbilities.DEFAULT_SHOVEL_ACTIONS) || Compatibility.isTinkersTool(itemStack, equipmentType)).setEquipmentLevel(ModEquipmentTypes::vanillaToolLevel).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> axe = ModEquipmentTypes.register("axe", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.axe")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ItemAbilities.DEFAULT_AXE_ACTIONS) || Compatibility.isTinkersTool(itemStack, equipmentType)).setEquipmentLevel(ModEquipmentTypes::vanillaToolLevel).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> hoe = ModEquipmentTypes.register("hoe", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.hoe")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ItemAbilities.DEFAULT_HOE_ACTIONS) || Compatibility.isTinkersTool(itemStack, equipmentType)).setEquipmentLevel(ModEquipmentTypes::vanillaToolLevel).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> sword = ModEquipmentTypes.register("sword", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.sword")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ItemAbilities.DEFAULT_SWORD_ACTIONS) || Compatibility.isTinkersWeapon(itemStack)).setEquipmentLevel((itemStack, equipmentType) -> {
        if (Compatibility.isTinkersWeapon(itemStack)) {
            return Compatibility.getToolLevel(itemStack);
        }
        Item patt0$temp = itemStack.getItem();
        if (patt0$temp instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)patt0$temp;
            return (int)tieredItem.getTier().getAttackDamageBonus();
        }
        return -1;
    }).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> bow = ModEquipmentTypes.register("bow", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.bow")).setIsEquipment((itemStack, equipmentType) -> itemStack.getItem() instanceof BowItem).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.durabilityBasedLevel(itemStack, Items.BOW.getMaxDamage(itemStack))).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> fishing_rod = ModEquipmentTypes.register("rod", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.fishingrod")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ItemAbilities.DEFAULT_FISHING_ROD_ACTIONS)).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.durabilityBasedLevel(itemStack, Items.FISHING_ROD.getMaxDamage(itemStack))).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> shears = ModEquipmentTypes.register("shears", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.shears")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ItemAbilities.DEFAULT_SHEARS_ACTIONS)).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.durabilityBasedLevel(itemStack, Items.SHEARS.getMaxDamage(itemStack))).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> shield = ModEquipmentTypes.register("shield", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.shield")).setIsEquipment((itemStack, equipmentType) -> ModEquipmentTypes.canPerformDefaultActions(itemStack, ItemAbilities.DEFAULT_SHIELD_ACTIONS)).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.durabilityBasedLevel(itemStack, Items.SHIELD.getMaxDamage(itemStack))).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> helmet = ModEquipmentTypes.register("helmet", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.helmet")).setIsEquipment((itemStack, equipmentType) -> {
        ArmorItem armor;
        Item patt0$temp = itemStack.getItem();
        return patt0$temp instanceof ArmorItem && EquipmentSlot.HEAD.equals((Object)(armor = (ArmorItem)patt0$temp).getEquipmentSlot());
    }).setEquipmentLevel((itemStack, equipmentType) -> ItemStackUtils.getArmorLevel(itemStack)).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> leggings = ModEquipmentTypes.register("leggings", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.leggings")).setIsEquipment((itemStack, equipmentType) -> {
        ArmorItem armor;
        Item patt0$temp = itemStack.getItem();
        return patt0$temp instanceof ArmorItem && EquipmentSlot.LEGS.equals((Object)(armor = (ArmorItem)patt0$temp).getEquipmentSlot());
    }).setEquipmentLevel((itemStack, equipmentType) -> ItemStackUtils.getArmorLevel(itemStack)).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> chestplate = ModEquipmentTypes.register("chestplate", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.chestplate")).setIsEquipment((itemStack, equipmentType) -> {
        ArmorItem armor;
        Item patt0$temp = itemStack.getItem();
        return patt0$temp instanceof ArmorItem && EquipmentSlot.CHEST.equals((Object)(armor = (ArmorItem)patt0$temp).getEquipmentSlot());
    }).setEquipmentLevel((itemStack, equipmentType) -> ItemStackUtils.getArmorLevel(itemStack)).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> boots = ModEquipmentTypes.register("boots", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.boots")).setIsEquipment((itemStack, equipmentType) -> {
        ArmorItem armor;
        Item patt0$temp = itemStack.getItem();
        return patt0$temp instanceof ArmorItem && EquipmentSlot.FEET.equals((Object)(armor = (ArmorItem)patt0$temp).getEquipmentSlot());
    }).setEquipmentLevel((itemStack, equipmentType) -> ItemStackUtils.getArmorLevel(itemStack)).build());
    public static final DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> flint_and_steel = ModEquipmentTypes.register("flintandsteel", builder -> builder.setDisplayName((Component)Component.translatable((String)"com.minecolonies.coremod.tooltype.lighter")).setIsEquipment((itemStack, equipmentType) -> itemStack.getItem() instanceof FlintAndSteelItem).setEquipmentLevel((itemStack, equipmentType) -> ModEquipmentTypes.durabilityBasedLevel(itemStack, Items.FLINT_AND_STEEL.getMaxDamage(itemStack))).build());

    public static Registry<EquipmentTypeEntry> getRegistry() {
        return IMinecoloniesAPI.getInstance().getEquipmentTypeRegistry();
    }

    private static DeferredHolder<EquipmentTypeEntry, EquipmentTypeEntry> register(String id, Consumer<EquipmentTypeEntry.Builder> consumer) {
        EquipmentTypeEntry.Builder equipmentType = new EquipmentTypeEntry.Builder().setRegistryName(new ResourceLocation("minecolonies", id));
        consumer.accept(equipmentType);
        return DEFERRED_REGISTER.register(id, equipmentType::build);
    }

    public static int vanillaToolLevel(ItemStack itemStack, EquipmentTypeEntry equipmentType) {
        if (Compatibility.isTinkersTool(itemStack, equipmentType)) {
            return Compatibility.getToolLevel(itemStack);
        }
        Item item = itemStack.getItem();
        if (item instanceof TieredItem) {
            TieredItem tieredItem = (TieredItem)item;
            return (int)tieredItem.getTier().getAttackDamageBonus();
        }
        return -1;
    }

    public static int durabilityBasedLevel(ItemStack itemStack, int vanillaItemDurability) {
        if (!itemStack.isDamageableItem()) {
            return 5;
        }
        return Math.min(itemStack.getMaxDamage() / vanillaItemDurability, 5);
    }

    public static boolean canPerformDefaultActions(ItemStack itemStack, Set<ItemAbility> actions) {
        for (ItemAbility toolAction : actions) {
            if (itemStack.canPerformAction(toolAction)) continue;
            return false;
        }
        return true;
    }
}

