/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.entity.other;

import com.minecolonies.api.entity.pathfinding.IStuckHandlerEntity;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.LookHandler;
import com.minecolonies.api.util.constant.ColonyConstants;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.portal.DimensionTransition;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractFastMinecoloniesEntity
extends PathfinderMob
implements IStuckHandlerEntity {
    private boolean canBeStuck = true;
    public final int randomVariance = ColonyConstants.rand.nextInt(20);
    private boolean isInFluid = false;
    private boolean onFire = false;
    private List<LivingEntity> entityPushCache = new ArrayList<LivingEntity>();
    private long lastHorizontalCollision = 0L;
    protected long lastKnockBack = 0L;
    final Byte ENABLE = 2;
    final Byte DISABLE = 0;

    protected AbstractFastMinecoloniesEntity(EntityType<? extends PathfinderMob> type, Level worldIn) {
        super(type, worldIn);
        this.lookControl = new LookHandler((Mob)this);
    }

    public boolean canBeLeashed() {
        return false;
    }

    @Override
    public boolean canBeStuck() {
        return this.canBeStuck;
    }

    public void setCanBeStuck(boolean canBeStuck) {
        this.canBeStuck = canBeStuck;
    }

    protected boolean isHorizontalCollisionMinor(Vec3 vec3) {
        this.lastHorizontalCollision = this.level().getGameTime();
        return super.isHorizontalCollisionMinor(vec3);
    }

    public boolean hadHorizontalCollission() {
        return this.level().getGameTime() - this.lastHorizontalCollision < 10L;
    }

    public boolean checkBedExists() {
        return false;
    }

    protected void removeFrost() {
    }

    protected void tryAddFrost() {
    }

    public void onInsideBubbleColumn(boolean down) {
    }

    protected int decreaseAirSupply(int supply) {
        return supply - 1;
    }

    protected int increaseAirSupply(int supply) {
        return supply + 1;
    }

    protected void onChangedBlock(ServerLevel level, BlockPos pos) {
    }

    public void pushEntities() {
        if (this.level().isClientSide()) {
            this.level().getEntities(EntityTypeTest.forClass(Player.class), this.getBoundingBox(), EntityUtils.pushableBy()).forEach(x$0 -> this.doPush((Entity)x$0));
        } else {
            if (this.tickCount % 10 == this.randomVariance % 10) {
                this.entityPushCache = this.level().getEntitiesOfClass(LivingEntity.class, this.getBoundingBox());
            }
            if (!this.entityPushCache.isEmpty()) {
                int entityPushCacheSize = this.entityPushCache.size();
                for (int i = 0; i < entityPushCacheSize; ++i) {
                    Entity entity = (Entity)this.entityPushCache.get(i);
                    if (!this.getBoundingBox().contains(entity.position())) continue;
                    this.doPush(entity);
                }
            }
        }
    }

    @Nullable
    public Entity changeDimension(DimensionTransition dimensionTransition) {
        return null;
    }

    public boolean canSpawnSprintParticle() {
        return false;
    }

    public void updateFluidOnEyes() {
        if (this.tickCount % 20 == this.randomVariance) {
            super.updateFluidOnEyes();
        }
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        if (this.tickCount % 10 == this.randomVariance % 10) {
            this.isInFluid = super.updateInWaterStateAndDoFluidPushing();
        }
        return this.isInFluid;
    }

    public void setSharedFlagOnFire(boolean newState) {
        if (newState != this.onFire) {
            super.setSharedFlagOnFire(newState);
            this.onFire = newState;
        }
    }

    protected void handlePortal() {
    }

    public void updateSwimming() {
    }

    public boolean isInWall() {
        if (this.tickCount % 10 == this.randomVariance % 10) {
            return super.isInWall();
        }
        return false;
    }

    public boolean isInWaterRainOrBubble() {
        if (this.getRemainingFireTicks() > 0 || this.level().isClientSide) {
            return super.isInWaterRainOrBubble();
        }
        return false;
    }

    public void updateFallFlying() {
        boolean flag;
        if (!this.level().isClientSide && this.tickCount % 5 == this.randomVariance % 5 && (!(flag = this.getSharedFlag(7)) || this.onGround() || this.isPassenger() || this.hasEffect(MobEffects.LEVITATION))) {
            flag = false;
            this.setSharedFlag(7, flag);
        }
    }

    protected void sendDebugPackets() {
    }

    public void setTicksFrozen(int p_146918_) {
    }

    public void updateSwimAmount() {
    }

    public void setShiftKeyDown(boolean enable) {
        if (enable) {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (Object)this.ENABLE);
        } else {
            this.entityData.set(DATA_SHARED_FLAGS_ID, (Object)this.DISABLE);
        }
    }

    public boolean isShiftKeyDown() {
        return ((Byte)this.entityData.get(DATA_SHARED_FLAGS_ID)).byteValue() == this.ENABLE.byteValue();
    }

    public void knockback(double power, double xRatio, double zRatio) {
        if (this.level().getGameTime() - this.lastKnockBack > 60L) {
            this.lastKnockBack = this.level().getGameTime();
            super.knockback(power, xRatio, zRatio);
        }
    }

    public boolean hurt(DamageSource dmgSource, float dmg) {
        AbstractFastMinecoloniesEntity otherFastMinecolEntity;
        Entity entity = dmgSource.getEntity();
        if (entity instanceof AbstractFastMinecoloniesEntity && (otherFastMinecolEntity = (AbstractFastMinecoloniesEntity)entity).getTeamId() == this.getTeamId()) {
            return false;
        }
        return super.hurt(dmgSource, dmg);
    }

    public abstract int getTeamId();
}

